@extends('layouts.app')
@section('title', 'Editar ' . $asset->code)
@section('content')
<div class="max-w-3xl">
    <div class="flex items-center gap-3 mb-6">
        <a href="{{ route('assets.show', $asset) }}" class="text-gray-400 hover:text-gray-600">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1 class="text-2xl font-bold text-gray-900">Editar: {{ $asset->code }}</h1>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="POST" action="{{ route('assets.update', $asset) }}">
            @csrf @method('PATCH')
            <div class="space-y-6">
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">Información básica</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nombre *</label>
                            <input type="text" name="name" value="{{ old('name', $asset->name) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Categoría *</label>
                            <select name="category_id" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ old('category_id',$asset->category_id) == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Estado *</label>
                            <select name="status" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                @foreach(\App\Models\Asset::$statuses as $key => $s)
                                <option value="{{ $key }}" {{ old('status',$asset->status) === $key ? 'selected' : '' }}>
                                    {{ $s['label'] }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Número de serie</label>
                            <input type="text" name="serial_number" value="{{ old('serial_number', $asset->serial_number) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ubicación</label>
                            <input type="text" name="location" value="{{ old('location', $asset->location) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                </div>

                {{-- Campos personalizados --}}
                @if($asset->category->customFields->count() > 0)
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">
                        Características técnicas
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($asset->category->customFields as $field)
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                {{ $field->label }}
                                @if($field->required) <span class="text-red-500">*</span> @endif
                            </label>
                            <input type="{{ in_array($field->type,['number']) ? 'number' : 'text' }}"
                                   name="custom_fields[{{ $field->id }}]"
                                   value="{{ old("custom_fields.{$field->id}", $asset->getFieldValue($field->id)) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">Asignación</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Departamento</label>
                            <select name="department_id" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">— Sin departamento —</option>
                                @foreach($departments as $dept)
                                <option value="{{ $dept->id }}" {{ old('department_id',$asset->department_id) == $dept->id ? 'selected' : '' }}>
                                    {{ $dept->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Asignado a</label>
                            <select name="assigned_to" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">— Sin asignar —</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('assigned_to',$asset->assigned_to) == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">
                                Razón del cambio de asignación
                            </label>
                            <input type="text" name="assignment_reason" placeholder="Ej: Cambio de área, reemplazo de equipo..."
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                </div>

                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">Adquisición</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Fecha compra</label>
                            <input type="date" name="purchase_date"
                                   value="{{ old('purchase_date', $asset->purchase_date?->format('Y-m-d')) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Valor</label>
                            <input type="number" name="purchase_price" step="0.01"
                                   value="{{ old('purchase_price', $asset->purchase_price) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Garantía hasta</label>
                            <input type="date" name="warranty_until"
                                   value="{{ old('warranty_until', $asset->warranty_until?->format('Y-m-d')) }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Notas</label>
                    <textarea name="notes" rows="3"
                              class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">{{ old('notes', $asset->notes) }}</textarea>
                </div>
            </div>

            <div class="flex gap-3 mt-6 pt-5 border-t border-gray-100">
                <button type="submit"
                        class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    Guardar cambios
                </button>
                <a href="{{ route('assets.show', $asset) }}"
                   class="px-5 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
                    Cancelar
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
