@extends('layouts.app')
@section('title', 'Inventario')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Inventario de Activos</h1>
        <p class="text-sm text-gray-500 mt-1">CMDB — Configuration Management Database</p>
    </div>
    @can('assets.create')
    <a href="{{ route('assets.create') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nuevo Activo
    </a>
    @endcan
</div>

{{-- Resumen por categoría --}}
<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-6">
    @foreach($categories as $cat)
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <div class="h-8 w-8 rounded-lg mb-2 flex items-center justify-center"
             style="background-color: {{ $cat->color }}20;">
            <div class="h-3 w-3 rounded-full" style="background-color: {{ $cat->color }}"></div>
        </div>
        <p class="text-xs text-gray-500 font-medium truncate">{{ $cat->name }}</p>
        <p class="text-xl font-bold text-gray-900 mt-0.5">{{ $cat->assets_count }}</p>
    </div>
    @endforeach
</div>

{{-- Alertas --}}
@php
    $expiringWarranty = \App\Models\Asset::whereNotNull('warranty_until')
        ->where('warranty_until', '>', now())
        ->where('warranty_until', '<=', now()->addDays(30))
        ->count();
@endphp
@if($expiringWarranty > 0)
<div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4 mb-5 flex items-center gap-3">
    <span class="text-yellow-500 text-lg">⚠</span>
    <p class="text-sm text-yellow-800">
        <strong>{{ $expiringWarranty }} activo(s)</strong> con garantía próxima a vencer (próximos 30 días).
    </p>
</div>
@endif

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <livewire:assets.asset-table />
</div>
@endsection
