@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')

@if(session('success'))
<div class="mb-4 p-4 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm flex items-center gap-2">
    <svg class="h-4 w-4 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
    </svg>
    {{ session('success') }}
</div>
@endif

<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Dashboard</h1>
    <p class="text-sm text-gray-500 mt-1">Bienvenido, {{ $user->name }}</p>
</div>

{{-- Métricas principales --}}
<div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
    <a href="{{ route('tickets.index') }}"
       class="bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Tickets abiertos</p>
            <div class="h-8 w-8 bg-blue-50 rounded-lg flex items-center justify-center">
                <svg class="h-4 w-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                </svg>
            </div>
        </div>
        <p class="text-3xl font-bold text-blue-600">{{ $ticketStats['open'] }}</p>
    </a>

    @if($isAgent)
    <a href="{{ route('tickets.index') }}?filterAgent={{ auth()->id() }}"
       class="bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Mis tickets</p>
            <div class="h-8 w-8 bg-purple-50 rounded-lg flex items-center justify-center">
                <svg class="h-4 w-4 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
            </div>
        </div>
        <p class="text-3xl font-bold text-purple-600">{{ $ticketStats['mine'] }}</p>
    </a>

    <div class="bg-white rounded-xl border border-gray-200 p-5">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">SLA Cumplimiento</p>
            <div class="h-8 w-8 {{ $slaStats['compliance'] >= 80 ? 'bg-green-50' : 'bg-red-50' }} rounded-lg flex items-center justify-center">
                <svg class="h-4 w-4 {{ $slaStats['compliance'] >= 80 ? 'text-green-600' : 'text-red-600' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
        </div>
        <p class="text-3xl font-bold {{ $slaStats['compliance'] >= 80 ? 'text-green-600' : 'text-red-600' }}">
            {{ $slaStats['compliance'] }}%
        </p>
    </div>

    <div class="bg-white rounded-xl border {{ $ticketStats['unassigned'] > 0 ? 'border-yellow-200 bg-yellow-50' : 'border-gray-200 bg-white' }} p-5">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold {{ $ticketStats['unassigned'] > 0 ? 'text-yellow-700' : 'text-gray-500' }} uppercase tracking-wide">Sin asignar</p>
            <div class="h-8 w-8 {{ $ticketStats['unassigned'] > 0 ? 'bg-yellow-100' : 'bg-gray-100' }} rounded-lg flex items-center justify-center">
                <svg class="h-4 w-4 {{ $ticketStats['unassigned'] > 0 ? 'text-yellow-600' : 'text-gray-500' }}" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
        </div>
        <p class="text-3xl font-bold {{ $ticketStats['unassigned'] > 0 ? 'text-yellow-600' : 'text-gray-900' }}">
            {{ $ticketStats['unassigned'] }}
        </p>
    </div>
    @else
    <div class="bg-white rounded-xl border border-gray-200 p-5">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Total tickets</p>
        </div>
        <p class="text-3xl font-bold text-gray-900">{{ $ticketStats['total'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-5">
        <div class="flex items-center justify-between mb-2">
            <p class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Resueltos</p>
        </div>
        <p class="text-3xl font-bold text-green-600">{{ $ticketStats['closed'] }}</p>
    </div>
    @endif
</div>

{{-- Alertas SLA --}}
@if($isAgent && ($slaStats['breached'] > 0 || $slaStats['warning'] > 0))
<div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
    @if($slaStats['breached'] > 0)
    <div class="bg-red-50 border border-red-200 rounded-xl p-4 flex items-center gap-3">
        <span class="text-red-500 text-xl">⚠</span>
        <div>
            <p class="text-sm font-semibold text-red-800">{{ $slaStats['breached'] }} ticket(s) con SLA vencido</p>
            <a href="{{ route('tickets.index') }}" class="text-xs text-red-600 hover:underline">Ver ahora →</a>
        </div>
    </div>
    @endif
    @if($slaStats['warning'] > 0)
    <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4 flex items-center gap-3">
        <span class="text-yellow-500 text-xl">⏰</span>
        <div>
            <p class="text-sm font-semibold text-yellow-800">{{ $slaStats['warning'] }} ticket(s) con SLA próximo a vencer</p>
            <a href="{{ route('tickets.index') }}" class="text-xs text-yellow-600 hover:underline">Ver ahora →</a>
        </div>
    </div>
    @endif
</div>
@endif

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">

    {{-- Actividad semanal --}}
    <div class="lg:col-span-2 bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Tickets creados — últimos 7 días</h3>
        @php $maxCount = max(array_merge(array_column($weeklyCreated, 'count'), [1])) @endphp
        <div class="flex items-end gap-2 h-28">
            @foreach($weeklyCreated as $day)
            <div class="flex-1 flex flex-col items-center gap-1">
                <span class="text-xs text-gray-500 font-medium">{{ $day['count'] ?: '' }}</span>
                <div class="w-full rounded-t-sm bg-blue-500 transition-all"
                     style="height: {{ $day['count'] > 0 ? max(8, ($day['count'] / $maxCount) * 80) : 4 }}px;
                            opacity: {{ $day['count'] > 0 ? 1 : 0.2 }}">
                </div>
                <span class="text-xs text-gray-400">{{ $day['day'] }}</span>
            </div>
            @endforeach
        </div>
    </div>

    {{-- Tickets por estado --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Por estado</h3>
        <div class="space-y-3">
            @foreach($byStatus as $status)
            @php $pct = $ticketStats['total'] > 0 ? round(($status->tickets_count / $ticketStats['total']) * 100) : 0 @endphp
            <div>
                <div class="flex justify-between items-center mb-1">
                    <span class="text-xs text-gray-600">{{ $status->name }}</span>
                    <span class="text-xs font-semibold" style="color: {{ $status->color }}">{{ $status->tickets_count }}</span>
                </div>
                <div class="h-1.5 bg-gray-100 rounded-full overflow-hidden">
                    <div class="h-full rounded-full transition-all"
                         style="width: {{ $pct }}%; background-color: {{ $status->color }}"></div>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    {{-- Tickets recientes --}}
    <div class="lg:col-span-2 bg-white rounded-xl shadow-sm border border-gray-200">
        <div class="px-5 py-4 border-b border-gray-200 flex items-center justify-between">
            <h3 class="text-sm font-semibold text-gray-900">Tickets recientes</h3>
            <a href="{{ route('tickets.index') }}" class="text-xs text-blue-600 hover:text-blue-800">Ver todos →</a>
        </div>
        <div class="divide-y divide-gray-100">
            @forelse($recentTickets as $ticket)
            <a href="{{ route('tickets.show', $ticket) }}"
               class="flex items-center gap-3 px-5 py-3 hover:bg-gray-50 transition">
                <span class="text-xs font-mono text-blue-600 w-20 flex-shrink-0">{{ $ticket->number }}</span>
                <span class="text-sm text-gray-800 flex-1 truncate">{{ $ticket->title }}</span>
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium flex-shrink-0"
                      style="background-color: {{ $ticket->priority->color }}20; color: {{ $ticket->priority->color }}">
                    {{ $ticket->priority->name }}
                </span>
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium flex-shrink-0"
                      style="background-color: {{ $ticket->status->color }}20; color: {{ $ticket->status->color }}">
                    {{ $ticket->status->name }}
                </span>
            </a>
            @empty
            <div class="px-5 py-8 text-center text-gray-400 text-sm">Sin tickets aún.</div>
            @endforelse
        </div>
    </div>

    {{-- Carga por agente --}}
    @if($isAgent && $agentLoad->count() > 0)
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Carga por agente</h3>
        <div class="space-y-3">
            @foreach($agentLoad as $agent)
            <div class="flex items-center gap-3">
                <img src="{{ $agent->avatar_url }}" class="h-7 w-7 rounded-full flex-shrink-0">
                <div class="flex-1 min-w-0">
                    <p class="text-xs font-medium text-gray-800 truncate">{{ $agent->name }}</p>
                    <div class="h-1.5 bg-gray-100 rounded-full mt-1 overflow-hidden">
                        @php $maxLoad = $agentLoad->max('assigned_tickets_count') ?: 1 @endphp
                        <div class="h-full bg-blue-500 rounded-full"
                             style="width: {{ ($agent->assigned_tickets_count / $maxLoad) * 100 }}%"></div>
                    </div>
                </div>
                <span class="text-sm font-bold text-gray-700 flex-shrink-0">{{ $agent->assigned_tickets_count }}</span>
            </div>
            @endforeach
        </div>
    </div>
    @elseif(!$isAgent)
    {{-- Para usuarios: acceso rápido al portal --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Acciones rápidas</h3>
        <div class="space-y-3">
            <a href="{{ route('portal.create') }}"
               class="flex items-center gap-3 p-3 bg-blue-50 rounded-lg hover:bg-blue-100 transition">
                <div class="h-8 w-8 bg-blue-100 rounded-lg flex items-center justify-center">
                    <svg class="h-4 w-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-blue-900">Nuevo ticket</p>
                    <p class="text-xs text-blue-600">Reportar un problema o solicitud</p>
                </div>
            </a>
            <a href="{{ route('portal.index') }}"
               class="flex items-center gap-3 p-3 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
                <div class="h-8 w-8 bg-gray-100 rounded-lg flex items-center justify-center">
                    <svg class="h-4 w-4 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-900">Mis solicitudes</p>
                    <p class="text-xs text-gray-500">Ver estado de mis tickets</p>
                </div>
            </a>
        </div>
    </div>
    @endif

    {{-- Activos (solo agentes) --}}
    @if($isAgent && !empty($assetStats))
    <div class="lg:col-span-3 grid grid-cols-2 md:grid-cols-4 gap-4">
        <div class="bg-white rounded-xl border border-gray-200 p-4">
            <p class="text-xs text-gray-500 font-medium uppercase">Total activos</p>
            <p class="text-2xl font-bold text-gray-900 mt-1">{{ $assetStats['total'] }}</p>
        </div>
        <div class="bg-white rounded-xl border border-gray-200 p-4">
            <p class="text-xs text-gray-500 font-medium uppercase">Activos</p>
            <p class="text-2xl font-bold text-green-600 mt-1">{{ $assetStats['active'] }}</p>
        </div>
        <div class="bg-white rounded-xl border border-gray-200 p-4">
            <p class="text-xs text-gray-500 font-medium uppercase">En reparación</p>
            <p class="text-2xl font-bold text-yellow-600 mt-1">{{ $assetStats['in_repair'] }}</p>
        </div>
        <div class="bg-white rounded-xl border border-gray-200 p-4 {{ $assetStats['warranty_soon'] > 0 ? 'border-yellow-200 bg-yellow-50' : '' }}">
            <p class="text-xs {{ $assetStats['warranty_soon'] > 0 ? 'text-yellow-700' : 'text-gray-500' }} font-medium uppercase">Garantía por vencer</p>
            <p class="text-2xl font-bold {{ $assetStats['warranty_soon'] > 0 ? 'text-yellow-600' : 'text-gray-400' }} mt-1">{{ $assetStats['warranty_soon'] }}</p>
        </div>
    </div>
    @endif

</div>
@endsection
