@extends('layouts.app')
@section('title', 'Departamentos')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Departamentos</h1>
        <p class="text-sm text-gray-500 mt-1">Estructura organizacional</p>
    </div>
    @can('departments.create')
    <a href="{{ route('departamentos.create') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nuevo Departamento
    </a>
    @endcan
</div>

<div class="space-y-3">
    @forelse($departments as $dept)
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <div class="h-10 w-10 rounded-lg flex items-center justify-center"
                     style="background-color: {{ $dept->color }}20;">
                    <div class="h-4 w-4 rounded-full" style="background-color: {{ $dept->color }};"></div>
                </div>
                <div>
                    <h3 class="text-sm font-semibold text-gray-900">{{ $dept->name }}</h3>
                    @if($dept->description)
                    <p class="text-xs text-gray-500 mt-0.5">{{ $dept->description }}</p>
                    @endif
                    <div class="flex gap-3 mt-1">
                        @if($dept->manager)
                        <span class="text-xs text-gray-400">Responsable: {{ $dept->manager->name }}</span>
                        @endif
                        <span class="text-xs text-gray-400">{{ $dept->users_count ?? $dept->users->count() }} usuarios</span>
                    </div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                    {{ $dept->active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                    {{ $dept->active ? 'Activo' : 'Inactivo' }}
                </span>
                @can('departments.edit')
                <a href="{{ route('departamentos.edit', $dept) }}"
                   class="text-blue-600 hover:text-blue-800 text-sm font-medium">Editar</a>
                @endcan
                @can('departments.delete')
                <form method="POST" action="{{ route('departamentos.destroy', $dept) }}"
                      onsubmit="return confirm('¿Eliminar departamento {{ $dept->name }}?')">
                    @csrf @method('DELETE')
                    <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium">Eliminar</button>
                </form>
                @endcan
            </div>
        </div>

        {{-- Sub-departamentos --}}
        @if($dept->children->count() > 0)
        <div class="mt-4 pl-8 space-y-2 border-l-2 border-gray-100">
            @foreach($dept->children as $child)
            <div class="flex items-center justify-between bg-gray-50 rounded-lg p-3">
                <div class="flex items-center gap-3">
                    <div class="h-3 w-3 rounded-full" style="background-color: {{ $child->color }};"></div>
                    <span class="text-sm text-gray-700 font-medium">{{ $child->name }}</span>
                    @if($child->manager)
                    <span class="text-xs text-gray-400">— {{ $child->manager->name }}</span>
                    @endif
                </div>
                @can('departments.edit')
                <a href="{{ route('departamentos.edit', $child) }}"
                   class="text-xs text-blue-600 hover:text-blue-800">Editar</a>
                @endcan
            </div>
            @endforeach
        </div>
        @endif
    </div>
    @empty
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-12 text-center text-gray-400 text-sm">
        No hay departamentos creados aún.
    </div>
    @endforelse
</div>
@endsection
