@extends('layouts.app')
@section('title', 'Gestión Base de Conocimiento')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Base de Conocimiento</h1>
        <p class="text-sm text-gray-500 mt-1">Gestión de artículos</p>
    </div>
    <div class="flex gap-3">
        <a href="{{ route('kb.index') }}"
           class="px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
            Ver portal →
        </a>
        <a href="{{ route('kb.admin.create') }}"
           class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            + Nuevo artículo
        </a>
    </div>
</div>

{{-- Filtros --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-4 mb-5">
    <form method="GET" class="flex gap-3">
        <select name="status" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            <option value="">Todos los estados</option>
            <option value="draft"     {{ request('status')==='draft'     ? 'selected':'' }}>Borrador</option>
            <option value="published" {{ request('status')==='published' ? 'selected':'' }}>Publicado</option>
            <option value="archived"  {{ request('status')==='archived'  ? 'selected':'' }}>Archivado</option>
        </select>
        <select name="category" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            <option value="">Todas las categorías</option>
            @foreach($categories as $cat)
            <option value="{{ $cat->id }}" {{ request('category')==$cat->id ? 'selected':'' }}>{{ $cat->name }}</option>
            @endforeach
        </select>
        <button type="submit" class="px-4 py-2 bg-blue-600 text-white text-sm rounded-lg hover:bg-blue-700 transition">
            Filtrar
        </button>
    </form>
</div>

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Artículo</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-32">Categoría</th>
                    <th class="px-4 py-3 text-center text-xs font-semibold text-gray-500 uppercase w-20">Vistas</th>
                    <th class="px-4 py-3 text-center text-xs font-semibold text-gray-500 uppercase w-20">Útil</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Autor</th>
                    <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase w-24">Acciones</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($articles as $article)
                <tr class="hover:bg-gray-50 {{ $article->trashed() ? 'opacity-50' : '' }}">
                    <td class="px-4 py-3">
                        <p class="text-sm font-medium text-gray-900">
                            {{ $article->title }}
                            @if($article->featured) <span class="text-yellow-400 ml-1">⭐</span> @endif
                        </p>
                        @if($article->tags)
                        <p class="text-xs text-gray-400 mt-0.5">{{ $article->tags }}</p>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                            {{ match($article->status) {
                                'published' => 'bg-green-100 text-green-800',
                                'draft'     => 'bg-yellow-100 text-yellow-800',
                                'archived'  => 'bg-gray-100 text-gray-600',
                                default     => 'bg-gray-100 text-gray-600',
                            } }}">
                            {{ match($article->status) {
                                'published' => 'Publicado',
                                'draft'     => 'Borrador',
                                'archived'  => 'Archivado',
                                default     => $article->status,
                            } }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $article->category?->name ?? '—' }}</td>
                    <td class="px-4 py-3 text-center text-sm text-gray-700">{{ $article->views }}</td>
                    <td class="px-4 py-3 text-center text-xs">
                        @if($article->helpful_rate !== null)
                        <span class="{{ $article->helpful_rate >= 70 ? 'text-green-600' : 'text-red-500' }} font-medium">
                            {{ $article->helpful_rate }}%
                        </span>
                        @else
                        <span class="text-gray-400">—</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $article->author->name }}</td>
                    <td class="px-4 py-3 text-right">
                        <div class="flex items-center justify-end gap-2">
                            @if($article->status === 'published')
                            <a href="{{ route('kb.show', $article->slug) }}" target="_blank"
                               class="text-xs text-gray-400 hover:text-gray-600">Ver</a>
                            @endif
                            @unless($article->trashed())
                            <a href="{{ route('kb.admin.edit', $article) }}"
                               class="text-xs text-blue-600 hover:text-blue-800 font-medium">Editar</a>
                            @endunless
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-4 py-8 text-center text-gray-400 text-sm">
                        No hay artículos. <a href="{{ route('kb.admin.create') }}" class="text-blue-600 hover:underline">Crear el primero</a>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($articles->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">{{ $articles->links() }}</div>
    @endif
</div>
@endsection
