@extends('layouts.app')
@section('title', $category->name)
@section('content')
<div class="flex items-center gap-3 mb-6">
    <a href="{{ route('kb.index') }}" class="text-gray-400 hover:text-gray-600">
        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
    </a>
    <div class="flex items-center gap-3">
        <div class="h-8 w-8 rounded-lg flex items-center justify-center"
             style="background-color: {{ $category->color }}20;">
            <div class="h-3 w-3 rounded-full" style="background-color: {{ $category->color }}"></div>
        </div>
        <h1 class="text-2xl font-bold text-gray-900">{{ $category->name }}</h1>
        <span class="text-sm text-gray-400">({{ $articles->total() }} artículos)</span>
    </div>
</div>

@if($category->description)
<p class="text-sm text-gray-500 mb-6">{{ $category->description }}</p>
@endif

{{-- Subcategorías --}}
@if($category->children->count() > 0)
<div class="grid grid-cols-2 md:grid-cols-4 gap-3 mb-6">
    @foreach($category->children as $child)
    <a href="{{ route('kb.category', $child->slug) }}"
       class="bg-white rounded-xl border border-gray-200 p-4 hover:shadow-md transition text-center">
        <p class="text-sm font-medium text-gray-900">{{ $child->name }}</p>
    </a>
    @endforeach
</div>
@endif

<div class="space-y-3">
    @forelse($articles as $article)
    <a href="{{ route('kb.show', $article->slug) }}"
       class="block bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md hover:border-blue-300 transition">
        <div class="flex items-start justify-between gap-4">
            <div class="flex-1">
                <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $article->title }}</h3>
                <p class="text-xs text-gray-500 line-clamp-2">{{ $article->excerpt }}</p>
                <div class="flex items-center gap-3 mt-2 text-xs text-gray-400">
                    <span>{{ $article->author->name }}</span>
                    <span>·</span>
                    <span>{{ $article->published_at?->format('d/m/Y') }}</span>
                    <span>·</span>
                    <span>{{ $article->views }} vistas</span>
                    @if($article->helpful_rate !== null)
                    <span>· 👍 {{ $article->helpful_rate }}%</span>
                    @endif
                </div>
            </div>
            <svg class="h-4 w-4 text-gray-400 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
        </div>
    </a>
    @empty
    <div class="bg-gray-50 rounded-xl p-8 text-center text-gray-400 text-sm">
        Sin artículos publicados en esta categoría.
    </div>
    @endforelse
</div>
@if($articles->hasPages())
<div class="mt-4">{{ $articles->links() }}</div>
@endif
@endsection
