@extends('layouts.app')
@section('title', 'Base de Conocimiento')
@section('content')

{{-- Hero / búsqueda --}}
<div class="bg-gradient-to-br from-blue-700 to-blue-900 rounded-2xl px-8 py-10 mb-8 text-center">
    <h1 class="text-3xl font-bold text-white mb-2">Base de Conocimiento</h1>
    <p class="text-blue-200 mb-6 text-sm">Encuentra guías, tutoriales y soluciones a problemas frecuentes</p>
    <form method="GET" class="max-w-xl mx-auto">
        <div class="flex gap-2">
            <input type="text" name="q" value="{{ $query }}"
                   placeholder="¿En qué te puedo ayudar? Ej: resetear contraseña, configurar correo..."
                   class="flex-1 rounded-xl border-0 px-4 py-3 text-sm text-gray-900 focus:ring-2 focus:ring-blue-300">
            <button type="submit"
                    class="px-5 py-3 bg-white text-blue-700 font-semibold text-sm rounded-xl hover:bg-blue-50 transition">
                Buscar
            </button>
        </div>
    </form>
</div>

{{-- Resultados de búsqueda --}}
@if($query)
<div class="mb-8">
    <div class="flex items-center gap-3 mb-4">
        <h2 class="text-lg font-semibold text-gray-900">
            Resultados para "{{ $query }}"
        </h2>
        <a href="{{ route('kb.index') }}" class="text-sm text-blue-600 hover:underline">Limpiar</a>
    </div>

    @if($articles->count() > 0)
    <div class="space-y-3">
        @foreach($articles as $article)
        <a href="{{ route('kb.show', $article->slug) }}"
           class="block bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md hover:border-blue-300 transition">
            <div class="flex items-start justify-between gap-4">
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $article->title }}</h3>
                    <p class="text-xs text-gray-500 line-clamp-2">{{ $article->excerpt }}</p>
                    <div class="flex items-center gap-3 mt-2">
                        @if($article->category)
                        <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                              style="background-color: {{ $article->category->color }}20; color: {{ $article->category->color }}">
                            {{ $article->category->name }}
                        </span>
                        @endif
                        <span class="text-xs text-gray-400">{{ $article->views }} vistas</span>
                        @if($article->helpful_rate !== null)
                        <span class="text-xs text-green-600">👍 {{ $article->helpful_rate }}% útil</span>
                        @endif
                    </div>
                </div>
                <svg class="h-4 w-4 text-gray-400 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </div>
        </a>
        @endforeach
    </div>
    <div class="mt-4">{{ $articles->links() }}</div>
    @else
    <div class="bg-gray-50 rounded-xl p-8 text-center">
        <p class="text-gray-500 text-sm mb-3">No encontramos artículos para "{{ $query }}"</p>
        <a href="{{ route('tickets.create') }}"
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Crear un ticket de soporte
        </a>
    </div>
    @endif
</div>
@else

{{-- Artículos destacados --}}
@if($featured->count() > 0)
<div class="mb-8">
    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-4">Artículos destacados</h2>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        @foreach($featured as $article)
        <a href="{{ route('kb.show', $article->slug) }}"
           class="block bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
            <div class="flex items-center gap-2 mb-2">
                @if($article->category)
                <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                      style="background-color: {{ $article->category->color }}20; color: {{ $article->category->color }}">
                    {{ $article->category->name }}
                </span>
                @endif
                <span class="text-xs text-yellow-500">⭐ Destacado</span>
            </div>
            <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $article->title }}</h3>
            <p class="text-xs text-gray-500 line-clamp-2">{{ $article->excerpt }}</p>
            <div class="flex items-center gap-3 mt-3 text-xs text-gray-400">
                <span>{{ $article->views }} vistas</span>
                @if($article->helpful_rate !== null)
                <span class="text-green-600">👍 {{ $article->helpful_rate }}%</span>
                @endif
            </div>
        </a>
        @endforeach
    </div>
</div>
@endif

{{-- Categorías --}}
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-8">
    @foreach($categories as $category)
    @if($category->articles_count > 0 || $category->children->count() > 0)
    <div class="bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
        <a href="{{ route('kb.category', $category->slug) }}" class="block">
            <div class="flex items-center gap-3 mb-3">
                <div class="h-10 w-10 rounded-xl flex items-center justify-center"
                     style="background-color: {{ $category->color }}20;">
                    <div class="h-4 w-4 rounded-full" style="background-color: {{ $category->color }}"></div>
                </div>
                <div>
                    <h3 class="text-sm font-semibold text-gray-900">{{ $category->name }}</h3>
                    <p class="text-xs text-gray-400">{{ $category->articles_count }} artículo(s)</p>
                </div>
            </div>
        </a>
        @if($category->description)
        <p class="text-xs text-gray-500 mb-3">{{ $category->description }}</p>
        @endif
        {{-- Últimos artículos de esta categoría --}}
        <div class="space-y-1.5">
            @foreach($category->articles->where('status','published')->take(3) as $art)
            <a href="{{ route('kb.show', $art->slug) }}"
               class="block text-xs text-blue-600 hover:text-blue-800 hover:underline truncate">
                → {{ $art->title }}
            </a>
            @endforeach
        </div>
    </div>
    @endif
    @endforeach
</div>

{{-- Artículos recientes --}}
@if($recent->count() > 0)
<div>
    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-4">Publicados recientemente</h2>
    <div class="bg-white rounded-xl border border-gray-200 divide-y divide-gray-100">
        @foreach($recent as $article)
        <a href="{{ route('kb.show', $article->slug) }}"
           class="flex items-center gap-4 px-5 py-3 hover:bg-gray-50 transition">
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium text-gray-900 truncate">{{ $article->title }}</p>
                @if($article->category)
                <p class="text-xs text-gray-400 mt-0.5">{{ $article->category->name }}</p>
                @endif
            </div>
            <span class="text-xs text-gray-400 flex-shrink-0">{{ $article->published_at?->format('d/m/y') }}</span>
        </a>
        @endforeach
    </div>
</div>
@endif

@endif
@endsection
