@extends('layouts.app')
@section('title', $article->title)
@section('content')
<div class="max-w-3xl">

    {{-- Breadcrumb --}}
    <div class="flex items-center gap-2 text-xs text-gray-400 mb-5">
        <a href="{{ route('kb.index') }}" class="hover:text-blue-600">Base de Conocimiento</a>
        @if($article->category)
        <span>›</span>
        <a href="{{ route('kb.category', $article->category->slug) }}" class="hover:text-blue-600">
            {{ $article->category->name }}
        </a>
        @endif
        <span>›</span>
        <span class="text-gray-600 truncate max-w-xs">{{ $article->title }}</span>
    </div>

    {{-- Artículo --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">

        {{-- Header --}}
        <div class="px-8 py-6 border-b border-gray-100">
            <div class="flex items-center gap-2 mb-3">
                @if($article->category)
                <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                      style="background-color: {{ $article->category->color }}20; color: {{ $article->category->color }}">
                    {{ $article->category->name }}
                </span>
                @endif
                @if($article->featured)
                <span class="text-xs text-yellow-500">⭐ Destacado</span>
                @endif
                @foreach($article->tags_array as $tag)
                <span class="text-xs bg-gray-100 text-gray-600 px-2 py-0.5 rounded-full">{{ $tag }}</span>
                @endforeach
            </div>
            <h1 class="text-2xl font-bold text-gray-900 mb-3">{{ $article->title }}</h1>
            <div class="flex items-center gap-4 text-xs text-gray-400">
                <span>Por {{ $article->author->name }}</span>
                <span>·</span>
                <span>{{ $article->published_at?->format('d/m/Y') }}</span>
                <span>·</span>
                <span>{{ $article->views }} vistas</span>
                @if($article->helpful_rate !== null)
                <span>·</span>
                <span class="text-green-600">{{ $article->helpful_rate }}% lo encontró útil</span>
                @endif
                @can('assets.edit')
                <span>·</span>
                <a href="{{ route('kb.admin.edit', $article) }}" class="text-blue-600 hover:underline">Editar</a>
                @endcan
            </div>
        </div>

        {{-- Contenido --}}
        <div class="px-8 py-6 prose prose-sm max-w-none
             prose-headings:font-semibold prose-headings:text-gray-900
             prose-a:text-blue-600 prose-a:no-underline hover:prose-a:underline
             prose-code:bg-gray-100 prose-code:px-1 prose-code:rounded
             prose-pre:bg-gray-900 prose-pre:text-gray-100
             prose-blockquote:border-blue-500 prose-blockquote:bg-blue-50 prose-blockquote:py-1">
            {!! $article->content !!}
        </div>

        {{-- ¿Fue útil? --}}
        <div class="px-8 py-5 border-t border-gray-100 bg-gray-50">
            <p class="text-sm font-medium text-gray-700 mb-3">¿Este artículo fue útil?</p>
            <div class="flex items-center gap-3">
                <form method="POST" action="{{ route('kb.vote', $article) }}" class="inline">
                    @csrf
                    <input type="hidden" name="helpful" value="1">
                    <button type="submit"
                            class="inline-flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium transition
                            {{ $article->user_vote === true ? 'bg-green-100 text-green-700 border-2 border-green-400' : 'bg-white border border-gray-300 text-gray-700 hover:bg-green-50' }}">
                        👍 Sí ({{ $article->helpful_yes }})
                    </button>
                </form>
                <form method="POST" action="{{ route('kb.vote', $article) }}" class="inline">
                    @csrf
                    <input type="hidden" name="helpful" value="0">
                    <button type="submit"
                            class="inline-flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium transition
                            {{ $article->user_vote === false ? 'bg-red-100 text-red-700 border-2 border-red-400' : 'bg-white border border-gray-300 text-gray-700 hover:bg-red-50' }}">
                        👎 No ({{ $article->helpful_no }})
                    </button>
                </form>
                @if(session('success'))
                <span class="text-xs text-green-600">{{ session('success') }}</span>
                @endif
            </div>
            <p class="text-xs text-gray-400 mt-3">
                ¿No encontraste lo que buscabas?
                <a href="{{ route('tickets.create') }}" class="text-blue-600 hover:underline">Crea un ticket de soporte</a>
            </p>
        </div>
    </div>

    {{-- Artículos relacionados --}}
    @if($related->count() > 0)
    <div class="mt-6">
        <h3 class="text-sm font-semibold text-gray-700 mb-3">Artículos relacionados</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
            @foreach($related as $rel)
            <a href="{{ route('kb.show', $rel->slug) }}"
               class="block bg-white rounded-xl border border-gray-200 p-4 hover:shadow-md transition">
                <p class="text-sm font-medium text-gray-900 mb-1">{{ $rel->title }}</p>
                <p class="text-xs text-gray-400 line-clamp-2">{{ $rel->excerpt }}</p>
            </a>
            @endforeach
        </div>
    </div>
    @endif

</div>
@endsection
