<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name') }} - @yield('title', 'Dashboard')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    @livewireStyles
</head>
<body class="bg-gray-100 font-sans antialiased">

{{-- Notificaciones flash --}}
@if(session('success'))
<div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 4000)"
     class="fixed top-4 right-4 z-50 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg text-sm font-medium">
    {{ session('success') }}
</div>
@endif
@if(session('error'))
<div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)"
     class="fixed top-4 right-4 z-50 bg-red-500 text-white px-6 py-3 rounded-lg shadow-lg text-sm font-medium">
    {{ session('error') }}
</div>
@endif

<div class="min-h-screen flex">
    {{-- Sidebar --}}
    <aside class="w-64 bg-gray-900 text-white flex flex-col min-h-screen fixed">
        {{-- Logo --}}
        <div class="px-6 py-5 border-b border-gray-700">
            <span class="text-2xl font-black text-blue-400 tracking-widest">NEXUS</span>
            <p class="text-xs text-gray-400 mt-0.5">Service Desk</p>
        </div>

        {{-- Navegación --}}
            <a href="{{ route('tickets.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('tickets.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>
                Tickets
            </a>
        <nav class="flex-1 px-3 py-4 space-y-1 overflow-y-auto">

            <a href="{{ route('dashboard') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('dashboard') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7h18M3 12h18M3 17h18"/>
                </svg>
                Dashboard
            </a>

            @can('users.index')
            <a href="{{ route('usuarios.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('usuarios.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Usuarios
            </a>
            @endcan

            @can('departments.index')
            <a href="{{ route('departamentos.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('departamentos.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16"/>
                </svg>
                Departamentos
            </a>
            @endcan

            @can('agent_groups.index')
            <a href="{{ route('grupos-agentes.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('grupos-agentes.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Grupos de Agentes
            </a>
            @endcan

            <a href="{{ route('assets.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('assets.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/></svg>
                Inventario
            </a>

            <a href="{{ route('kb.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('kb.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.746 0 3.332.477 4.5 1.253v13C19.832 18.477 18.246 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/></svg>
                Conocimiento
            </a>
            @if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte']))
            <a href="{{ route('reports.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('reports.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                Reportes
            </a>
            @endif
            @if(auth()->user()->hasAnyRole(['admin','superadmin']))
            <a href="{{ route('ai.admin') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('ai.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17H3a2 2 0 01-2-2V5a2 2 0 012-2h14a2 2 0 012 2v10a2 2 0 01-2 2h-2"/></svg>
                IA
                @php $kbPending = \App\Models\AiKbDraft::pending()->count(); @endphp
                @if($kbPending > 0)<span class="ml-auto text-xs bg-yellow-400 text-gray-900 font-bold px-1.5 py-0.5 rounded-full">{{ $kbPending }}</span>@endif
            </a>
            <a href="{{ route('api.docs') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('api.docs') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                API Docs
            </a>
            <a href="{{ route('admin.settings.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('admin.settings*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                Configuración
            </a>
            <a href="{{ route('admin.automations.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('admin.automations*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                Automatizaciones
            </a>
            <div class="pt-4 pb-2">
                <p class="px-3 text-xs font-semibold text-gray-500 uppercase tracking-wider">Administración</p>
            </div>
            <a href="{{ route('admin.settings.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('admin.settings') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                Configuración
            </a>
            <a href="{{ route('auditoria.index') }}"
               class="flex items-center px-3 py-2 text-sm rounded-lg {{ request()->routeIs('auditoria.*') ? 'bg-blue-600 text-white' : 'text-gray-300 hover:bg-gray-700' }} transition">
                <svg class="h-5 w-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                </svg>
                Auditoría
            </a>
            @endif

        </nav>

        {{-- Usuario en sesión --}}
        <div class="px-4 py-4 border-t border-gray-700">
            <div class="flex items-center">
                <img src="{{ auth()->user()->avatar_url }}" alt="{{ auth()->user()->name }}"
                     class="h-8 w-8 rounded-full mr-3 object-cover">
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-medium text-white truncate">{{ auth()->user()->name }}</p>
                    <p class="text-xs text-gray-400 truncate">{{ auth()->user()->getRoleNames()->first() ?? '—' }}</p>
                </div>
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="text-gray-400 hover:text-white transition" title="Cerrar sesión">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                        </svg>
                    </button>
                </form>
            </div>
        </div>
    </aside>

    {{-- Contenido principal --}}
    <main class="flex-1 ml-64">
        <div class="px-8 py-6">
            @yield('content')
        </div>
    </main>
</div>

@livewireScripts
</body>
</html>
