<div>
    <div class="sm:flex sm:items-center sm:justify-between mb-6">
        <div>
            <h3 class="text-lg font-semibold text-gray-900">Registro de Actividad</h3>
            <p class="mt-1 text-sm text-gray-500">Historial de acciones realizadas en el sistema.</p>
        </div>
    </div>

    <div class="mb-4 grid grid-cols-1 sm:grid-cols-2 gap-4">
        <input wire:model.live.debounce.300ms="search" type="text" placeholder="Buscar en actividad..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm" />
        <select wire:model.live="filterType" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm">
            <option value="">Todos los eventos</option>
            <option value="created">Creación</option>
            <option value="updated">Actualización</option>
            <option value="deleted">Eliminación</option>
        </select>
    </div>

    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Fecha</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Usuario</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Acción</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Descripción</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($activities as $activity)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-xs text-gray-500">{{ $activity->created_at->format('d/m/Y H:i') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700">{{ $activity->causer?->name ?? 'Sistema' }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                                @switch($activity->event)
                                    @case('created') bg-green-100 text-green-800 @break
                                    @case('updated') bg-blue-100 text-blue-800 @break
                                    @case('deleted') bg-red-100 text-red-800 @break
                                    @default bg-gray-100 text-gray-800
                                @endswitch
                            ">{{ ucfirst($activity->event ?? 'acción') }}</span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-500">{{ $activity->description }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                            <p class="text-sm">No hay actividad registrada aún.</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="px-6 py-3 border-t border-gray-200">
            {{ $activities->links() }}
        </div>
    </div>
</div>
