<div>
    {{-- Filtros --}}
    <div class="p-4 border-b border-gray-200 bg-gray-50 rounded-t-xl">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
            <div class="col-span-2 md:col-span-1">
                <input wire:model.live.debounce.300ms="search" type="text"
                       placeholder="Código, nombre, serie, usuario..."
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <select wire:model.live="filterCat"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todas las categorías</option>
                @foreach(\App\Models\AssetCategory::active()->get() as $cat)
                <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                @endforeach
            </select>
            <select wire:model.live="filterStatus"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los estados</option>
                @foreach(\App\Models\Asset::$statuses as $key => $s)
                <option value="{{ $key }}">{{ $s['label'] }}</option>
                @endforeach
            </select>
            <select wire:model.live="filterDept"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los departamentos</option>
                @foreach(\App\Models\Department::active()->get() as $dept)
                <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                @endforeach
            </select>
        </div>
    </div>

    {{-- Tabla --}}
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Código</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Activo</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Categoría</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-36">Asignado a</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Garantía</th>
                    <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase w-20">Acciones</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($assets as $asset)
                <tr class="hover:bg-gray-50 transition">
                    <td class="px-4 py-3">
                        <span class="text-sm font-mono font-semibold text-blue-600">{{ $asset->code }}</span>
                    </td>
                    <td class="px-4 py-3">
                        <p class="text-sm font-medium text-gray-900">{{ $asset->name }}</p>
                        <p class="text-xs text-gray-400 mt-0.5">
                            {{ $asset->model?->manufacturer?->name }} {{ $asset->model?->name }}
                            @if($asset->serial_number) · S/N: {{ $asset->serial_number }} @endif
                        </p>
                    </td>
                    <td class="px-4 py-3">
                        <div class="flex items-center gap-1.5">
                            <div class="h-2.5 w-2.5 rounded-full flex-shrink-0"
                                 style="background-color: {{ $asset->category->color }}"></div>
                            <span class="text-sm text-gray-700">{{ $asset->category->name }}</span>
                        </div>
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $asset->status_color }}">
                            {{ $asset->status_label }}
                        </span>
                    </td>
                    <td class="px-4 py-3">
                        @if($asset->assignedUser)
                        <div class="flex items-center gap-2">
                            <img src="{{ $asset->assignedUser->avatar_url }}" class="h-6 w-6 rounded-full">
                            <span class="text-xs text-gray-700 truncate max-w-24">{{ $asset->assignedUser->name }}</span>
                        </div>
                        @else
                        <span class="text-xs text-gray-400">Sin asignar</span>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        @if($asset->warranty_until)
                            @if($asset->isWarrantyExpired())
                            <span class="text-xs text-red-500">Vencida</span>
                            @elseif($asset->isWarrantyExpiringSoon())
                            <span class="text-xs text-yellow-500">⚠ {{ $asset->warranty_until->format('d/m/y') }}</span>
                            @else
                            <span class="text-xs text-green-600">{{ $asset->warranty_until->format('d/m/y') }}</span>
                            @endif
                        @else
                        <span class="text-xs text-gray-400">—</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-right">
                        <a href="{{ route('assets.show', $asset) }}"
                           class="text-blue-600 hover:text-blue-800 text-sm font-medium">Ver</a>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-4 py-12 text-center text-gray-400 text-sm">
                        No se encontraron activos con los filtros aplicados.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($assets->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">{{ $assets->links() }}</div>
    @endif
</div>
