<div>
    {{-- Saludo y rol --}}
    <div class="mb-6">
        <h3 class="text-lg font-semibold text-gray-900">
            Bienvenido, {{ auth()->user()->name }}
        </h3>
        <p class="text-sm text-gray-500">
            Rol: <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                @switch($userRole)
                    @case('admin')   bg-red-100    text-red-800    @break
                    @case('gerente') bg-purple-100 text-purple-800 @break
                    @case('editor')  bg-blue-100   text-blue-800   @break
                    @case('viewer')  bg-gray-100   text-gray-800   @break
                    @default         bg-gray-100   text-gray-800
                @endswitch
            ">{{ ucfirst($userRole) }}</span>
            · {{ now()->translatedFormat('l, d \d\e F Y') }}
        </p>
    </div>

    {{-- Cards genéricas — reemplazar con métricas del proyecto --}}
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">

        {{-- Card 1 — Usuarios (solo admin/gerente) --}}
        @can('users.index')
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-indigo-100 rounded-lg p-3">
                    <svg class="h-6 w-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-500">Usuarios</p>
                    <p class="text-2xl font-bold text-gray-900">{{ $data['totalUsuarios'] ?? 0 }}</p>
                    <p class="text-xs text-green-600">{{ $data['usuariosActivos'] ?? 0 }} activos</p>
                </div>
            </div>
        </div>
        @endcan

        {{-- 
            ── ZONA DE CONSTRUCCIÓN ──────────────────────────────────────
            Agrega aquí las cards con métricas del proyecto específico.
            Ejemplo de estructura:

            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-green-100 rounded-lg p-3">
                        [SVG icono]
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-medium text-gray-500">Nombre métrica</p>
                        <p class="text-2xl font-bold text-gray-900">{{ $data['clave'] ?? 0 }}</p>
                    </div>
                </div>
            </div>
        --}}

    </div>

    {{-- Accesos rápidos — poblar con rutas del proyecto --}}
    @can('users.index')
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6 mb-6">
        <h4 class="text-sm font-semibold text-gray-700 mb-4">Accesos Rápidos</h4>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3">

            <a href="{{ route('usuarios.index') }}"
               class="flex items-center p-3 bg-gray-50 rounded-lg hover:bg-indigo-50 transition"
               wire:navigate>
                <svg class="h-5 w-5 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                <span class="text-sm text-gray-700">Usuarios</span>
            </a>

            {{-- Agrega aquí más accesos rápidos del proyecto --}}

        </div>
    </div>
    @endcan

    {{-- Estado del sistema --}}
    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
        <h4 class="text-sm font-semibold text-gray-700 mb-3">Estado del Sistema</h4>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-xs text-gray-500">
            <div><span class="font-medium text-gray-700">Laravel:</span> ✅ v12</div>
            <div><span class="font-medium text-gray-700">Spatie Permissions:</span> ✅ Activo</div>
            <div><span class="font-medium text-gray-700">Activity Log:</span> ✅ Activo</div>
            <div><span class="font-medium text-gray-700">Livewire:</span> ✅ v3</div>
        </div>
    </div>

</div>
