<div class="relative" x-data="{ open: @entangle('open') }">

    {{-- Botón campanita --}}
    <button wire:click="toggle"
            class="relative p-2 text-gray-400 hover:text-gray-200 transition rounded-lg hover:bg-gray-700">
        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
        </svg>
        @if($unreadCount > 0)
        <span class="absolute -top-0.5 -right-0.5 h-4 w-4 bg-red-500 text-white text-xs rounded-full flex items-center justify-center font-bold">
            {{ $unreadCount > 9 ? '9+' : $unreadCount }}
        </span>
        @endif
    </button>

    {{-- Panel desplegable --}}
    <div x-show="open"
         x-transition:enter="transition ease-out duration-150"
         x-transition:enter-start="opacity-0 scale-95"
         x-transition:enter-end="opacity-100 scale-100"
         x-transition:leave="transition ease-in duration-100"
         x-transition:leave-start="opacity-100 scale-100"
         x-transition:leave-end="opacity-0 scale-95"
         @click.outside="open = false"
         class="absolute right-0 top-10 w-80 bg-white rounded-xl shadow-xl border border-gray-200 z-50 overflow-hidden"
         style="display:none">

        {{-- Header --}}
        <div class="flex items-center justify-between px-4 py-3 border-b border-gray-100 bg-gray-50">
            <h3 class="text-sm font-semibold text-gray-900">
                Notificaciones
                @if($unreadCount > 0)
                <span class="ml-1.5 text-xs bg-blue-100 text-blue-700 px-1.5 py-0.5 rounded-full">
                    {{ $unreadCount }} nuevas
                </span>
                @endif
            </h3>
            @if($unreadCount > 0)
            <button wire:click="markAllRead"
                    class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                Marcar todas leídas
            </button>
            @endif
        </div>

        {{-- Lista --}}
        <div class="max-h-96 overflow-y-auto divide-y divide-gray-100">
            @forelse($notifications as $notif)
            <div wire:key="notif-{{ $notif->id }}"
                 class="flex items-start gap-3 px-4 py-3 hover:bg-gray-50 transition cursor-pointer
                        {{ is_null($notif->read_at) ? 'bg-blue-50' : '' }}"
                 wire:click="markRead({{ $notif->id }})"
                 @if($notif->url) onclick="window.location.href='{{ $notif->url }}'" @endif>

                {{-- Ícono con color --}}
                <div class="flex-shrink-0 h-8 w-8 rounded-full flex items-center justify-center mt-0.5
                            {{ match($notif->color) {
                                'blue'   => 'bg-blue-100 text-blue-600',
                                'green'  => 'bg-green-100 text-green-600',
                                'red'    => 'bg-red-100 text-red-600',
                                'yellow' => 'bg-yellow-100 text-yellow-600',
                                'purple' => 'bg-purple-100 text-purple-600',
                                default  => 'bg-gray-100 text-gray-600',
                            } }}">
                    @if($notif->icon === 'check-circle')
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    @elseif($notif->icon === 'exclamation')
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                    </svg>
                    @elseif($notif->icon === 'user-check')
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    @elseif($notif->icon === 'chat')
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                    </svg>
                    @elseif($notif->icon === 'clock')
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    @else
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                    </svg>
                    @endif
                </div>

                <div class="flex-1 min-w-0">
                    <p class="text-xs font-semibold text-gray-900 leading-snug">{{ $notif->title }}</p>
                    <p class="text-xs text-gray-500 mt-0.5 leading-snug line-clamp-2">{{ $notif->body }}</p>
                    <p class="text-xs text-gray-400 mt-1">{{ $notif->created_at->diffForHumans() }}</p>
                </div>

                @if(is_null($notif->read_at))
                <div class="flex-shrink-0 h-2 w-2 rounded-full bg-blue-500 mt-1.5"></div>
                @endif
            </div>
            @empty
            <div class="px-4 py-10 text-center text-gray-400 text-sm">
                Sin notificaciones
            </div>
            @endforelse
        </div>

        {{-- Footer --}}
        <div class="px-4 py-2 border-t border-gray-100 bg-gray-50">
            <a href="{{ route('notifications.index') }}"
               class="text-xs text-blue-600 hover:text-blue-800 font-medium">
                Ver todas las notificaciones →
            </a>
        </div>
    </div>
</div>
