<div>
    {{-- Tabs de grupos --}}
    <div class="flex gap-1 bg-white rounded-xl shadow-sm border border-gray-200 p-1 mb-5 flex-wrap">
        @php
            $tabGroups = ['general' => 'General', 'mail' => 'Correo', 'appearance' => 'Apariencia', 'sla' => 'SLA', 'tickets' => 'Tickets'];
        @endphp
        @foreach($tabGroups as $groupKey => $groupLabel)
        <button wire:click="$set('activeGroup', '{{ $groupKey }}')"
                class="flex-1 py-2 px-3 text-sm font-medium rounded-lg transition min-w-fit
                    {{ $activeGroup === $groupKey ? 'bg-blue-600 text-white' : 'text-gray-500 hover:text-gray-700 hover:bg-gray-50' }}">
            {{ $groupLabel }}
        </button>
        @endforeach
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        @if($configs->isEmpty())
            <p class="text-sm text-gray-400 text-center py-8">
                No hay configuraciones en este grupo aún.
            </p>
        @else
        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
            @foreach($configs as $config)
            <div class="{{ ($config->type === 'text' && strlen($config->value ?? '') > 80) ? 'md:col-span-2' : '' }}">
                <label class="block text-sm font-medium text-gray-700 mb-1">
                    {{ $config->label }}
                    @if($config->description)
                    <span class="text-xs text-gray-400 font-normal ml-1">— {{ $config->description }}</span>
                    @endif
                </label>

                @if($config->type === 'boolean')
                <div class="flex items-center gap-2">
                    <input type="checkbox"
                           wire:model="values.{{ $config->key }}"
                           value="1"
                           {{ ($values[$config->key] ?? '0') == '1' ? 'checked' : '' }}
                           class="rounded border-gray-300 text-blue-600">
                    <span class="text-sm text-gray-500">Habilitado</span>
                </div>
                @elseif($config->type === 'color')
                <input type="color"
                       wire:model="values.{{ $config->key }}"
                       class="h-10 w-full rounded-lg border-gray-300 cursor-pointer">
                @elseif($config->type === 'number')
                <input type="number"
                       wire:model="values.{{ $config->key }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                @else
                <input type="text"
                       wire:model="values.{{ $config->key }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                @endif
            </div>
            @endforeach
        </div>
        <div class="mt-6 pt-5 border-t border-gray-100 flex items-center gap-3">
            <button wire:click="save"
                    class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                <span wire:loading.remove wire:target="save">Guardar configuración</span>
                <span wire:loading wire:target="save">Guardando...</span>
            </button>
            <span wire:loading.remove wire:target="save" class="text-xs text-gray-400">
                Los cambios se aplican inmediatamente
            </span>
        </div>
        @endif
    </div>
</div>
