<div>
    {{-- Filtros --}}
    <div class="p-4 border-b border-gray-200 bg-gray-50 rounded-t-xl">
        <div class="grid grid-cols-2 md:grid-cols-5 gap-3">
            <div class="col-span-2">
                <input wire:model.live.debounce.300ms="search" type="text"
                       placeholder="Buscar por número, título o solicitante..."
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <select wire:model.live="filterStatus"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los estados</option>
                @foreach(\App\Models\TicketStatus::active()->get() as $s)
                <option value="{{ $s->id }}">{{ $s->name }}</option>
                @endforeach
            </select>
            <select wire:model.live="filterPriority"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todas las prioridades</option>
                @foreach(\App\Models\TicketPriority::active()->get() as $p)
                <option value="{{ $p->id }}">{{ $p->name }}</option>
                @endforeach
            </select>
            @if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte']))
            <select wire:model.live="filterAgent"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los agentes</option>
                @foreach(\App\Models\User::active()->agents()->get() as $a)
                <option value="{{ $a->id }}">{{ $a->name }}</option>
                @endforeach
            </select>
            @endif
        </div>
        @if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte','agente']))
        <div class="mt-2 flex gap-3">
            <label class="flex items-center gap-2 text-sm text-gray-600 cursor-pointer">
                <input type="checkbox" wire:model.live="filterMine" value="1"
                       class="rounded border-gray-300 text-blue-600">
                Solo mis tickets
            </label>
        </div>
        @endif
    </div>

    {{-- Tabla --}}
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Número</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Título</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Prioridad</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-32">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-36">SLA</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-36">Agente</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Creado</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($tickets as $ticket)
                <tr class="hover:bg-gray-50 cursor-pointer transition"
                    onclick="window.location='{{ route('tickets.show', $ticket) }}'">
                    <td class="px-4 py-3">
                        <span class="text-sm font-mono font-semibold text-blue-600">{{ $ticket->number }}</span>
                    </td>
                    <td class="px-4 py-3">
                        <p class="text-sm font-medium text-gray-900 line-clamp-1">{{ $ticket->title }}</p>
                        @if($ticket->category)
                        <p class="text-xs text-gray-400 mt-0.5">{{ $ticket->category->name }}</p>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                              style="background-color: {{ $ticket->priority->color }}20; color: {{ $ticket->priority->color }}">
                            {{ $ticket->priority->name }}
                        </span>
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                              style="background-color: {{ $ticket->status->color }}20; color: {{ $ticket->status->color }}">
                            {{ $ticket->status->name }}
                        </span>
                    </td>
                    <td class="px-4 py-3">
                        @php $sla = $ticket->sla_status @endphp
                        @if($sla === 'breached')
                        <span class="text-xs text-red-600 font-medium">⚠ {{ $ticket->sla_remaining }}</span>
                        @elseif($sla === 'warning')
                        <span class="text-xs text-yellow-600 font-medium">⏰ {{ $ticket->sla_remaining }}</span>
                        @elseif($sla === 'ok')
                        <span class="text-xs text-green-600">✓ {{ $ticket->sla_remaining }}</span>
                        @else
                        <span class="text-xs text-gray-400">—</span>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        @if($ticket->assignee)
                        <div class="flex items-center gap-2">
                            <img src="{{ $ticket->assignee->avatar_url }}" class="h-6 w-6 rounded-full">
                            <span class="text-xs text-gray-700">{{ $ticket->assignee->name }}</span>
                        </div>
                        @else
                        <span class="text-xs text-red-500 font-medium">Sin asignar</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-xs text-gray-500">
                        {{ $ticket->created_at->format('d/m/y H:i') }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="px-4 py-12 text-center text-gray-400 text-sm">
                        No se encontraron tickets con los filtros aplicados.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($tickets->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">{{ $tickets->links() }}</div>
    @endif
</div>
