<div>
    {{-- Filtros --}}
    <div class="p-4 border-b border-gray-200 bg-gray-50 rounded-t-xl">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
            <input wire:model.live.debounce.300ms="search" type="text" placeholder="Buscar por nombre, email..."
                   class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500 w-full">
            <select wire:model.live="filterRole" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los roles</option>
                @foreach(\Spatie\Permission\Models\Role::orderBy('name')->get() as $role)
                    <option value="{{ $role->name }}">{{ ucfirst($role->name) }}</option>
                @endforeach
            </select>
            <select wire:model.live="filterDept" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los departamentos</option>
                @foreach(\App\Models\Department::active()->orderBy('name')->get() as $dept)
                    <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                @endforeach
            </select>
            <select wire:model.live="filterStatus" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los estados</option>
                <option value="1">Activos</option>
                <option value="0">Inactivos</option>
            </select>
        </div>
    </div>

    {{-- Tabla --}}
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Usuario</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Rol</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Departamento</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estado</th>
                    <th class="px-6 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Acciones</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($users as $user)
                <tr class="hover:bg-gray-50 transition">
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <img src="{{ $user->avatar_url }}" alt="{{ $user->name }}"
                                 class="h-9 w-9 rounded-full mr-3 object-cover">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $user->name }}</p>
                                <p class="text-xs text-gray-500">{{ $user->email }}</p>
                                @if($user->position)
                                <p class="text-xs text-gray-400">{{ $user->position }}</p>
                                @endif
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        @foreach($user->roles as $role)
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                            {{ ucfirst($role->name) }}
                        </span>
                        @endforeach
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600">
                        {{ $user->department?->name ?? '—' }}
                    </td>
                    <td class="px-6 py-4">
                        <button wire:click="toggleStatus({{ $user->id }})"
                                class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium cursor-pointer
                                {{ $user->is_active ? 'bg-green-100 text-green-800 hover:bg-green-200' : 'bg-red-100 text-red-800 hover:bg-red-200' }} transition">
                            {{ $user->is_active ? 'Activo' : 'Inactivo' }}
                        </button>
                    </td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex justify-end gap-2">
                            @can('users.edit')
                            <a href="{{ route('usuarios.edit', $user) }}"
                               class="text-blue-600 hover:text-blue-800 text-sm font-medium">Editar</a>
                            @endcan
                            @can('users.delete')
                            @if($user->id !== auth()->id())
                            <form method="POST" action="{{ route('usuarios.destroy', $user) }}"
                                  onsubmit="return confirm('¿Eliminar usuario {{ $user->name }}?')">
                                @csrf @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium">Eliminar</button>
                            </form>
                            @endif
                            @endcan
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="px-6 py-12 text-center text-gray-400 text-sm">
                        No se encontraron usuarios con los filtros aplicados.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{-- Paginación --}}
    @if($users->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">
        {{ $users->links() }}
    </div>
    @endif
</div>
