@extends('layouts.app')
@section('title', 'Mis Solicitudes')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Mis Solicitudes</h1>
        <p class="text-sm text-gray-500 mt-1">Seguimiento de tus tickets</p>
    </div>
    <a href="{{ route('portal.create') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nueva Solicitud
    </a>
</div>

{{-- Stats --}}
<div class="grid grid-cols-3 gap-4 mb-6">
    <div class="bg-white rounded-xl border border-gray-200 p-4 text-center">
        <p class="text-xs text-gray-500 uppercase font-medium">Abiertas</p>
        <p class="text-2xl font-bold text-blue-600 mt-1">{{ $stats['open'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4 text-center">
        <p class="text-xs text-gray-500 uppercase font-medium">Resueltas</p>
        <p class="text-2xl font-bold text-green-600 mt-1">{{ $stats['closed'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4 text-center">
        <p class="text-xs text-gray-500 uppercase font-medium">Total</p>
        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total'] }}</p>
    </div>
</div>

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="divide-y divide-gray-100">
        @forelse($tickets as $ticket)
        <a href="{{ route('portal.show', $ticket) }}"
           class="flex items-center gap-4 px-6 py-4 hover:bg-gray-50 transition">
            <div class="flex-1 min-w-0">
                <div class="flex items-center gap-2 mb-1">
                    <span class="text-xs font-mono text-blue-600">{{ $ticket->number }}</span>
                    <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                          style="background-color: {{ $ticket->priority->color }}20; color: {{ $ticket->priority->color }}">
                        {{ $ticket->priority->name }}
                    </span>
                </div>
                <p class="text-sm font-medium text-gray-900 truncate">{{ $ticket->title }}</p>
                <p class="text-xs text-gray-400 mt-0.5">{{ $ticket->created_at->format('d/m/Y H:i') }}</p>
            </div>
            <div class="flex-shrink-0">
                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium"
                      style="background-color: {{ $ticket->status->color }}20; color: {{ $ticket->status->color }}">
                    {{ $ticket->status->name }}
                </span>
            </div>
            @if(!$ticket->satisfaction_score && $ticket->status->is_final)
            <div class="flex-shrink-0">
                <span class="text-xs bg-yellow-100 text-yellow-700 px-2 py-1 rounded-full">Califica ★</span>
            </div>
            @endif
        </a>
        @empty
        <div class="px-6 py-16 text-center">
            <svg class="h-12 w-12 text-gray-300 mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
            </svg>
            <p class="text-sm text-gray-400 mb-3">No tienes solicitudes aún</p>
            <a href="{{ route('portal.create') }}"
               class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700">
                Crear mi primera solicitud
            </a>
        </div>
        @endforelse
    </div>
    @if($tickets->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">{{ $tickets->links() }}</div>
    @endif
</div>
@endsection
