@extends('layouts.app')
@section('title', 'Notificaciones')
@section('content')
<div class="max-w-2xl">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Notificaciones</h1>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
        @forelse($notifications as $notif)
        <div class="flex items-start gap-4 px-6 py-4 {{ is_null($notif->read_at) ? 'bg-blue-50' : '' }}">
            <div class="flex-shrink-0 h-9 w-9 rounded-full flex items-center justify-center
                        {{ match($notif->color) {
                            'blue'   => 'bg-blue-100 text-blue-600',
                            'green'  => 'bg-green-100 text-green-600',
                            'red'    => 'bg-red-100 text-red-600',
                            'yellow' => 'bg-yellow-100 text-yellow-600',
                            'purple' => 'bg-purple-100 text-purple-600',
                            default  => 'bg-gray-100 text-gray-600',
                        } }}">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                          d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
                </svg>
            </div>
            <div class="flex-1">
                <p class="text-sm font-semibold text-gray-900">{{ $notif->title }}</p>
                <p class="text-sm text-gray-600 mt-0.5">{{ $notif->body }}</p>
                <p class="text-xs text-gray-400 mt-1">{{ $notif->created_at->format('d/m/Y H:i') }}</p>
            </div>
            @if($notif->url)
            <a href="{{ $notif->url }}" class="text-xs text-blue-600 hover:text-blue-800 flex-shrink-0">Ver →</a>
            @endif
        </div>
        @empty
        <div class="px-6 py-12 text-center text-gray-400 text-sm">Sin notificaciones</div>
        @endforelse
    </div>
    @if($notifications->hasPages())
    <div class="mt-4">{{ $notifications->links() }}</div>
    @endif
</div>
@endsection
