@extends('layouts.app')
@section('title', $ticket->number)
@section('content')
@if(session('success'))
<div class="mb-4 p-4 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm">
    {{ session('success') }}
</div>
@endif

<div class="max-w-2xl">
    <div class="flex items-center gap-3 mb-6">
        <a href="{{ route('portal.index') }}" class="text-gray-400 hover:text-gray-600">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <span class="font-mono font-bold text-blue-600">{{ $ticket->number }}</span>
        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium"
              style="background-color: {{ $ticket->status->color }}20; color: {{ $ticket->status->color }}">
            {{ $ticket->status->name }}
        </span>
    </div>

    {{-- Encuesta de satisfacción --}}
    @if($ticket->status->is_final && !$ticket->satisfaction_score)
    <div class="bg-blue-50 border border-blue-200 rounded-xl p-5 mb-5">
        <h3 class="text-sm font-semibold text-blue-900 mb-3">⭐ ¿Cómo fue la atención de tu solicitud?</h3>
        <form method="POST" action="{{ route('portal.satisfaction', $ticket) }}">
            @csrf
            <div class="flex gap-2 mb-3">
                @for($i = 1; $i <= 5; $i++)
                <label class="cursor-pointer">
                    <input type="radio" name="score" value="{{ $i }}" class="sr-only" required>
                    <span class="text-2xl hover:scale-110 transition-transform block"
                          onclick="this.parentElement.querySelector('input').checked=true; highlightStars({{ $i }})">⭐</span>
                </label>
                @endfor
            </div>
            <input type="hidden" name="score" id="scoreInput" value="">
            <div class="flex gap-2 mb-3">
                @for($i = 1; $i <= 5; $i++)
                <button type="button"
                        onclick="document.getElementById('scoreInput').value='{{ $i }}'; this.parentElement.querySelectorAll('button').forEach((b,j) => b.classList.toggle('bg-yellow-400', j < {{ $i }})); "
                        class="flex-1 py-2 text-lg bg-gray-100 rounded-lg hover:bg-yellow-200 transition">
                    {{ $i }}⭐
                </button>
                @endfor
            </div>
            <textarea name="comment" rows="2" placeholder="Comentario opcional..."
                      class="w-full rounded-lg border-gray-300 text-sm mb-3 focus:ring-blue-500 focus:border-blue-500"></textarea>
            <button type="submit"
                    class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                Enviar calificación
            </button>
        </form>
    </div>
    @elseif($ticket->satisfaction_score)
    <div class="bg-green-50 border border-green-200 rounded-xl p-4 mb-5 flex items-center gap-3">
        <span class="text-green-500">✓</span>
        <p class="text-sm text-green-800">
            Calificaste esta atención con <strong>{{ $ticket->satisfaction_score }}/5</strong> estrellas. ¡Gracias!
        </p>
    </div>
    @endif

    {{-- Descripción --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 mb-5">
        <h2 class="text-lg font-bold text-gray-900 mb-2">{{ $ticket->title }}</h2>
        <p class="text-sm text-gray-600 whitespace-pre-wrap">{{ $ticket->description }}</p>
        <div class="flex items-center gap-4 mt-4 text-xs text-gray-400">
            <span>Creado: {{ $ticket->created_at->format('d/m/Y H:i') }}</span>
            <span>Prioridad:
                <span style="color: {{ $ticket->priority->color }}" class="font-medium">
                    {{ $ticket->priority->name }}
                </span>
            </span>
            @if($ticket->sla_resolution_due && !$ticket->status->is_final)
            <span>SLA: {{ $ticket->sla_remaining }}</span>
            @endif
        </div>
    </div>

    {{-- Conversación --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-sm font-semibold text-gray-900">Conversación</h3>
        </div>

        <div class="divide-y divide-gray-100">
            @forelse($ticket->comments->where('is_internal', false) as $comment)
            <div class="px-6 py-4 flex gap-3 {{ $comment->user_id === auth()->id() ? '' : 'bg-gray-50' }}">
                <img src="{{ $comment->user->avatar_url }}" class="h-8 w-8 rounded-full flex-shrink-0">
                <div class="flex-1">
                    <div class="flex items-center gap-2 mb-1">
                        <span class="text-sm font-medium text-gray-900">
                            {{ $comment->user_id === auth()->id() ? 'Tú' : $comment->user->name }}
                        </span>
                        <span class="text-xs text-gray-400">{{ $comment->created_at->diffForHumans() }}</span>
                    </div>
                    <p class="text-sm text-gray-700">{{ $comment->body }}</p>
                </div>
            </div>
            @empty
            <div class="px-6 py-8 text-center text-gray-400 text-sm">
                Sin mensajes aún. Puedes escribirnos si tienes más información.
            </div>
            @endforelse
        </div>

        @if(!$ticket->status->is_final)
        <div class="px-6 py-4 border-t border-gray-200 bg-gray-50 rounded-b-xl">
            <form method="POST" action="{{ route('portal.comment', $ticket) }}">
                @csrf
                <textarea name="body" rows="3" placeholder="Escribe un mensaje o información adicional..."
                          class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500 mb-3"></textarea>
                <button type="submit"
                        class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    Enviar mensaje
                </button>
            </form>
        </div>
        @endif
    </div>
</div>
@endsection
