@extends('layouts.app')
@section('title', 'Reporte de Inventario')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div class="flex items-center gap-3">
        <a href="{{ route('reports.index') }}" class="text-gray-400 hover:text-gray-600">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1 class="text-2xl font-bold text-gray-900">Reporte de Inventario</h1>
    </div>
    <div class="flex gap-2">
        <a href="{{ route('reports.export.inventory.csv') }}"
           class="inline-flex items-center px-3 py-2 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition">
            ↓ CSV
        </a>
        <a href="{{ route('reports.export.inventory.pdf') }}"
           class="inline-flex items-center px-3 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition">
            ↓ PDF
        </a>
    </div>
</div>

{{-- Métricas --}}
<div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Total activos</p>
        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $assets->count() }}</p>
    </div>
    @foreach($byStatus as $key => $s)
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">{{ $s['label'] }}</p>
        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $s['count'] }}</p>
    </div>
    @endforeach
</div>

{{-- Alertas garantía --}}
@if($warrantyExpired > 0 || $warrantySoon > 0)
<div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
    @if($warrantyExpired > 0)
    <div class="bg-red-50 border border-red-200 rounded-xl p-4 flex items-center gap-3">
        <span class="text-red-500 text-xl">⚠</span>
        <p class="text-sm text-red-800"><strong>{{ $warrantyExpired }} activo(s)</strong> con garantía vencida</p>
    </div>
    @endif
    @if($warrantySoon > 0)
    <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4 flex items-center gap-3">
        <span class="text-yellow-500 text-xl">⏰</span>
        <p class="text-sm text-yellow-800"><strong>{{ $warrantySoon }} activo(s)</strong> con garantía por vencer (30 días)</p>
    </div>
    @endif
</div>
@endif

{{-- Por categoría --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 mb-6">
    <h3 class="text-sm font-semibold text-gray-900 mb-4">Por categoría</h3>
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-7 gap-3">
        @foreach($byCategory as $name => $data)
        <div class="p-3 bg-gray-50 rounded-xl text-center">
            <div class="h-3 w-3 rounded-full mx-auto mb-2" style="background-color: {{ $data['color'] }}"></div>
            <p class="text-xs text-gray-500 leading-tight mb-1">{{ $name }}</p>
            <p class="text-xl font-bold text-gray-900">{{ $data['count'] }}</p>
            @if($data['value'] > 0)
            <p class="text-xs text-gray-400 mt-0.5">${{ number_format($data['value'], 0, ',', '.') }}</p>
            @endif
        </div>
        @endforeach
    </div>
    @if($totalValue > 0)
    <div class="mt-4 pt-4 border-t border-gray-100 text-right">
        <span class="text-sm text-gray-500">Valor total del inventario: </span>
        <span class="text-base font-bold text-gray-900">${{ number_format($totalValue, 0, ',', '.') }}</span>
    </div>
    @endif
</div>

{{-- Tabla --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-sm font-semibold text-gray-900">Detalle del inventario ({{ $assets->count() }})</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Código</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Nombre</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Categoría</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Asignado a</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Garantía</th>
                    <th class="px-4 py-3 text-right text-xs font-semibold text-gray-500 uppercase">Valor</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($assets as $asset)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <a href="{{ route('assets.show', $asset) }}"
                           class="text-sm font-mono text-blue-600 hover:underline">{{ $asset->code }}</a>
                    </td>
                    <td class="px-4 py-3">
                        <p class="text-sm text-gray-900">{{ $asset->name }}</p>
                        @if($asset->serial_number)
                        <p class="text-xs text-gray-400">S/N: {{ $asset->serial_number }}</p>
                        @endif
                    </td>
                    <td class="px-4 py-3">
                        <span class="flex items-center gap-1.5 text-sm text-gray-700">
                            <span class="h-2 w-2 rounded-full" style="background-color: {{ $asset->category->color }}"></span>
                            {{ $asset->category->name }}
                        </span>
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $asset->status_color }}">
                            {{ $asset->status_label }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $asset->assignedUser?->name ?? '—' }}</td>
                    <td class="px-4 py-3">
                        @if($asset->warranty_until)
                            <span class="text-xs {{ $asset->isWarrantyExpired() ? 'text-red-500 font-medium' : ($asset->isWarrantyExpiringSoon() ? 'text-yellow-500' : 'text-green-600') }}">
                                {{ $asset->warranty_until->format('d/m/Y') }}
                            </span>
                        @else
                        <span class="text-xs text-gray-400">—</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-right text-sm text-gray-700">
                        {{ $asset->purchase_price ? '$'.number_format($asset->purchase_price, 0, ',', '.') : '—' }}
                    </td>
                </tr>
                @empty
                <tr><td colspan="7" class="px-4 py-8 text-center text-gray-400 text-sm">Sin activos registrados.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
