<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<style>
* { margin:0; padding:0; box-sizing:border-box; }
body { font-family: DejaVu Sans, sans-serif; font-size: 9px; color: #1f2937; }
.header { background: #1e3a5f; color: white; padding: 14px 20px; margin-bottom: 14px; }
.header h1 { font-size: 16px; font-weight: bold; }
.header p  { font-size: 10px; color: #93c5fd; margin-top: 2px; }
.summary { display: flex; gap: 10px; margin: 0 20px 14px; flex-wrap: wrap; }
.sum-item { background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 6px; padding: 6px 12px; text-align: center; min-width: 80px; }
.sum-val { font-size: 16px; font-weight: bold; color: #1e3a5f; }
.sum-lbl { font-size: 8px; color: #6b7280; text-transform: uppercase; }
.section-title { font-size: 11px; font-weight: bold; color: #374151; margin: 0 20px 6px; }
table { width: calc(100% - 40px); margin: 0 20px 10px; border-collapse: collapse; }
th { background: #f3f4f6; padding: 5px 6px; text-align: left; font-size: 8px; text-transform: uppercase; color: #6b7280; border-bottom: 1px solid #e5e7eb; }
td { padding: 4px 6px; border-bottom: 1px solid #f3f4f6; font-size: 8px; }
tr:nth-child(even) td { background: #f9fafb; }
.footer { margin-top: 8px; padding: 6px 20px; border-top: 1px solid #e5e7eb; font-size: 8px; color: #9ca3af; }
</style>
</head>
<body>
<div class="header">
    <h1>NEXUS Service Desk — Inventario CMDB</h1>
    <p>Generado: {{ now()->format('d/m/Y H:i') }} · {{ $assets->count() }} activos registrados</p>
</div>

<div class="summary">
    @foreach($byCategory as $name => $data)
    <div class="sum-item">
        <div class="sum-val">{{ $data['count'] }}</div>
        <div class="sum-lbl">{{ $name }}</div>
        @if($data['value'] > 0)
        <div style="font-size:7px;color:#6b7280">${{ number_format($data['value'], 0, ',', '.') }}</div>
        @endif
    </div>
    @endforeach
</div>

<p class="section-title">Detalle del inventario</p>
<table>
    <thead>
        <tr>
            <th>Código</th><th>Nombre</th><th>Categoría</th><th>N° Serie</th>
            <th>Estado</th><th>Asignado a</th><th>Departamento</th><th>Garantía</th><th>Valor</th>
        </tr>
    </thead>
    <tbody>
        @foreach($assets as $a)
        <tr>
            <td style="color:#2563eb;font-weight:bold;font-family:monospace">{{ $a->code }}</td>
            <td>{{ mb_strimwidth($a->name, 0, 35, '...') }}</td>
            <td>{{ $a->category->name }}</td>
            <td style="font-family:monospace">{{ $a->serial_number ?? '—' }}</td>
            <td>{{ $a->status_label }}</td>
            <td>{{ $a->assignedUser?->name ?? '—' }}</td>
            <td>{{ $a->department?->name ?? '—' }}</td>
            <td style="color:{{ $a->isWarrantyExpired() ? '#dc2626' : '#16a34a' }}">
                {{ $a->warranty_until?->format('d/m/y') ?? '—' }}
            </td>
            <td style="text-align:right">{{ $a->purchase_price ? '$'.number_format($a->purchase_price,0,',','.') : '—' }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<div class="footer">
    NEXUS Service Desk · Inventario CMDB · {{ now()->format('d/m/Y H:i') }}
</div>
</body>
</html>
