<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<style>
* { margin:0; padding:0; box-sizing:border-box; }
body { font-family: DejaVu Sans, sans-serif; font-size: 9px; color: #1f2937; }
.header { background: #1e3a5f; color: white; padding: 14px 20px; margin-bottom: 14px; }
.header h1 { font-size: 16px; font-weight: bold; }
.header p  { font-size: 10px; color: #93c5fd; margin-top: 2px; }
.metrics { display: flex; gap: 10px; margin: 0 20px 14px; }
.metric { flex: 1; background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 6px; padding: 8px 12px; text-align: center; }
.metric-value { font-size: 20px; font-weight: bold; color: #1e3a5f; }
.metric-label { font-size: 8px; color: #6b7280; text-transform: uppercase; margin-top: 2px; }
.section-title { font-size: 11px; font-weight: bold; color: #374151; margin: 0 20px 6px; }
table { width: calc(100% - 40px); margin: 0 20px 14px; border-collapse: collapse; }
th { background: #f3f4f6; padding: 5px 8px; text-align: left; font-size: 8px; text-transform: uppercase; color: #6b7280; border-bottom: 1px solid #e5e7eb; }
td { padding: 5px 8px; border-bottom: 1px solid #f3f4f6; font-size: 8px; }
tr:nth-child(even) td { background: #f9fafb; }
.badge { display: inline-block; padding: 2px 6px; border-radius: 4px; font-size: 7px; font-weight: bold; }
.footer { margin-top: 10px; padding: 8px 20px; border-top: 1px solid #e5e7eb; font-size: 8px; color: #9ca3af; }
</style>
</head>
<body>
<div class="header">
    <h1>NEXUS Service Desk — Reporte de Tickets</h1>
    <p>Período: {{ \Carbon\Carbon::parse($from)->format('d/m/Y') }} — {{ \Carbon\Carbon::parse($to)->format('d/m/Y') }} · Generado: {{ now()->format('d/m/Y H:i') }}</p>
</div>

<div class="metrics">
    <div class="metric"><div class="metric-value">{{ $metrics['total'] }}</div><div class="metric-label">Total</div></div>
    <div class="metric"><div class="metric-value" style="color:#16a34a">{{ $metrics['closed'] }}</div><div class="metric-label">Cerrados</div></div>
    <div class="metric"><div class="metric-value" style="color:{{ ($metrics['total']>0 ? round((($metrics['closed']-$metrics['sla_breached'])/$metrics['closed'])*100) : 100) >= 80 ? '#16a34a' : '#dc2626' }}">
        {{ $metrics['total']>0 && $metrics['closed']>0 ? round((($metrics['closed']-$metrics['sla_breached'])/$metrics['closed'])*100) : 100 }}%
    </div><div class="metric-label">SLA Cump.</div></div>
    <div class="metric"><div class="metric-value" style="color:#dc2626">{{ $metrics['sla_breached'] }}</div><div class="metric-label">SLA Breach</div></div>
    <div class="metric"><div class="metric-value" style="color:#d97706">{{ $metrics['avg_sat'] ? $metrics['avg_sat'].'/5' : '—' }}</div><div class="metric-label">Satisfacción</div></div>
</div>

<p class="section-title">Detalle de tickets</p>
<table>
    <thead>
        <tr>
            <th>Número</th><th>Título</th><th>Estado</th><th>Prioridad</th>
            <th>Agente</th><th>SLA</th><th>Creado</th>
        </tr>
    </thead>
    <tbody>
        @foreach($tickets as $t)
        <tr>
            <td style="color:#2563eb;font-weight:bold;font-family:monospace">{{ $t->number }}</td>
            <td style="max-width:180px">{{ mb_strimwidth($t->title, 0, 50, '...') }}</td>
            <td><span class="badge" style="background:{{ $t->status->color }}20;color:{{ $t->status->color }}">{{ $t->status->name }}</span></td>
            <td style="color:{{ $t->priority->color }};font-weight:bold">{{ $t->priority->name }}</td>
            <td>{{ $t->assignee?->name ?? '—' }}</td>
            <td style="color:{{ $t->sla_resolution_breached ? '#dc2626' : '#16a34a' }}">
                {{ $t->sla_resolution_breached ? 'BREACH' : 'OK' }}
            </td>
            <td>{{ $t->created_at->format('d/m/y H:i') }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

<div class="footer">
    NEXUS Service Desk · {{ now()->format('d/m/Y H:i') }} · {{ $tickets->count() }} tickets en el período
</div>
</body>
</html>
