@extends('layouts.app')
@section('title', 'Reporte SLA')
@section('content')
<div class="flex items-center gap-3 mb-6">
    <a href="{{ route('reports.index') }}" class="text-gray-400 hover:text-gray-600">
        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Cumplimiento SLA</h1>
</div>

{{-- Filtro de período --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 mb-6">
    <form method="GET" class="flex items-end gap-4">
        <div>
            <label class="block text-xs font-medium text-gray-700 mb-1">Desde</label>
            <input type="date" name="from" value="{{ $from }}"
                   class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
        </div>
        <div>
            <label class="block text-xs font-medium text-gray-700 mb-1">Hasta</label>
            <input type="date" name="to" value="{{ $to }}"
                   class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
        </div>
        <button type="submit" class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Aplicar
        </button>
    </form>
</div>

{{-- Cumplimiento por prioridad --}}
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
    @foreach($byPriority as $p)
    <div class="bg-white rounded-xl border border-gray-200 p-5">
        <div class="flex items-center justify-between mb-3">
            <span class="text-sm font-semibold" style="color: {{ $p['color'] }}">{{ $p['name'] }}</span>
            <span class="text-xs text-gray-400">SLA: {{ $p['sla_hours'] }}h</span>
        </div>
        <div class="text-3xl font-bold {{ $p['compliance'] >= 80 ? 'text-green-600' : 'text-red-600' }} mb-2">
            {{ $p['compliance'] }}%
        </div>
        <div class="h-2 bg-gray-100 rounded-full overflow-hidden mb-3">
            <div class="h-full rounded-full transition-all {{ $p['compliance'] >= 80 ? 'bg-green-500' : 'bg-red-500' }}"
                 style="width: {{ $p['compliance'] }}%"></div>
        </div>
        <div class="flex justify-between text-xs text-gray-500">
            <span>{{ $p['on_time'] }} a tiempo</span>
            <span class="{{ $p['breached'] > 0 ? 'text-red-500 font-medium' : '' }}">{{ $p['breached'] }} breach</span>
        </div>
        <p class="text-xs text-gray-400 mt-1">{{ $p['closed'] }} de {{ $p['total'] }} cerrados</p>
    </div>
    @endforeach
</div>

{{-- Tickets en breach activo --}}
@if($activeBreach->count() > 0)
<div class="bg-red-50 border border-red-200 rounded-xl mb-6">
    <div class="px-6 py-4 border-b border-red-200">
        <h3 class="text-sm font-semibold text-red-800">
            ⚠ Tickets con SLA vencido ({{ $activeBreach->count() }})
        </h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full">
            <thead>
                <tr class="bg-red-100">
                    <th class="px-4 py-2 text-left text-xs font-semibold text-red-700">Número</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-red-700">Título</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-red-700">Prioridad</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-red-700">Agente</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-red-700">Venció</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-red-100">
                @foreach($activeBreach as $ticket)
                <tr class="hover:bg-red-100">
                    <td class="px-4 py-2">
                        <a href="{{ route('tickets.show', $ticket) }}" class="text-sm font-mono text-red-700 hover:underline">
                            {{ $ticket->number }}
                        </a>
                    </td>
                    <td class="px-4 py-2 text-sm text-red-800 max-w-xs truncate">{{ $ticket->title }}</td>
                    <td class="px-4 py-2 text-xs font-medium" style="color: {{ $ticket->priority->color }}">
                        {{ $ticket->priority->name }}
                    </td>
                    <td class="px-4 py-2 text-sm text-red-700">{{ $ticket->assignee?->name ?? 'Sin asignar' }}</td>
                    <td class="px-4 py-2 text-xs text-red-600 font-medium">
                        {{ $ticket->sla_resolution_due?->format('d/m/Y H:i') }}
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif

{{-- Tickets próximos a vencer --}}
@if($warning->count() > 0)
<div class="bg-yellow-50 border border-yellow-200 rounded-xl">
    <div class="px-6 py-4 border-b border-yellow-200">
        <h3 class="text-sm font-semibold text-yellow-800">
            ⏰ Tickets próximos a vencer — próximas 4 horas ({{ $warning->count() }})
        </h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full">
            <thead>
                <tr class="bg-yellow-100">
                    <th class="px-4 py-2 text-left text-xs font-semibold text-yellow-700">Número</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-yellow-700">Título</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-yellow-700">Prioridad</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-yellow-700">Agente</th>
                    <th class="px-4 py-2 text-left text-xs font-semibold text-yellow-700">Vence en</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-yellow-100">
                @foreach($warning as $ticket)
                <tr>
                    <td class="px-4 py-2">
                        <a href="{{ route('tickets.show', $ticket) }}" class="text-sm font-mono text-yellow-700 hover:underline">
                            {{ $ticket->number }}
                        </a>
                    </td>
                    <td class="px-4 py-2 text-sm text-yellow-800 max-w-xs truncate">{{ $ticket->title }}</td>
                    <td class="px-4 py-2 text-xs font-medium" style="color: {{ $ticket->priority->color }}">
                        {{ $ticket->priority->name }}
                    </td>
                    <td class="px-4 py-2 text-sm">{{ $ticket->assignee?->name ?? 'Sin asignar' }}</td>
                    <td class="px-4 py-2 text-xs text-yellow-700 font-medium">{{ $ticket->sla_remaining }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif

@if($activeBreach->isEmpty() && $warning->isEmpty())
<div class="bg-green-50 border border-green-200 rounded-xl p-8 text-center">
    <div class="text-4xl mb-2">✅</div>
    <p class="text-sm font-semibold text-green-800">Todos los SLAs están en orden</p>
    <p class="text-xs text-green-600 mt-1">No hay tickets con SLA vencido ni próximo a vencer</p>
</div>
@endif
@endsection
