@extends('layouts.app')
@section('title', 'Reporte de Tickets')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div class="flex items-center gap-3">
        <a href="{{ route('reports.index') }}" class="text-gray-400 hover:text-gray-600">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1 class="text-2xl font-bold text-gray-900">Reporte de Tickets</h1>
    </div>
    <div class="flex gap-2">
        <a href="{{ route('reports.export.tickets.csv', ['from'=>$from,'to'=>$to,'agent'=>$agent]) }}"
           class="inline-flex items-center px-3 py-2 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition">
            ↓ CSV
        </a>
        <a href="{{ route('reports.export.tickets.pdf', ['from'=>$from,'to'=>$to]) }}"
           class="inline-flex items-center px-3 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition">
            ↓ PDF
        </a>
    </div>
</div>

{{-- Filtros --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5 mb-6">
    <form method="GET" class="flex items-end gap-4 flex-wrap">
        <div>
            <label class="block text-xs font-medium text-gray-700 mb-1">Desde</label>
            <input type="date" name="from" value="{{ $from }}"
                   class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
        </div>
        <div>
            <label class="block text-xs font-medium text-gray-700 mb-1">Hasta</label>
            <input type="date" name="to" value="{{ $to }}"
                   class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
        </div>
        <div>
            <label class="block text-xs font-medium text-gray-700 mb-1">Agente</label>
            <select name="agent" class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los agentes</option>
                @foreach($agents as $a)
                <option value="{{ $a->id }}" {{ $agent == $a->id ? 'selected' : '' }}>{{ $a->name }}</option>
                @endforeach
            </select>
        </div>
        <button type="submit"
                class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Aplicar filtros
        </button>
    </form>
</div>

{{-- Métricas --}}
<div class="grid grid-cols-2 md:grid-cols-6 gap-4 mb-6">
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Total</p>
        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $metrics['total'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Abiertos</p>
        <p class="text-2xl font-bold text-blue-600 mt-1">{{ $metrics['open'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Cerrados</p>
        <p class="text-2xl font-bold text-green-600 mt-1">{{ $metrics['closed'] }}</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">SLA Cump.</p>
        <p class="text-2xl font-bold {{ $slaCompliance >= 80 ? 'text-green-600' : 'text-red-600' }} mt-1">{{ $slaCompliance }}%</p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Resolución</p>
        <p class="text-2xl font-bold text-gray-900 mt-1">
            {{ $metrics['avg_resolution'] ? $metrics['avg_resolution'].'h' : '—' }}
        </p>
    </div>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 uppercase">Satisfacción</p>
        <p class="text-2xl font-bold text-yellow-500 mt-1">
            {{ $metrics['satisfaction'] ? $metrics['satisfaction'].'/5' : '—' }}
        </p>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">

    {{-- Tendencia diaria --}}
    <div class="lg:col-span-2 bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Tendencia diaria</h3>
        @php $maxDaily = max(array_merge(array_column($daily, 'created'), array_column($daily, 'closed'), [1])) @endphp
        <div class="overflow-x-auto">
            <div class="flex items-end gap-1 h-32 min-w-max">
                @foreach($daily as $d)
                <div class="flex flex-col items-center gap-1 w-8">
                    <div class="w-full flex flex-col-reverse gap-0.5">
                        <div class="w-full bg-blue-400 rounded-t-sm"
                             style="height: {{ $d['created'] > 0 ? max(4, ($d['created']/$maxDaily)*80) : 2 }}px" title="Creados: {{ $d['created'] }}"></div>
                        <div class="w-full bg-green-400 rounded-t-sm"
                             style="height: {{ $d['closed'] > 0 ? max(4, ($d['closed']/$maxDaily)*80) : 2 }}px" title="Cerrados: {{ $d['closed'] }}"></div>
                    </div>
                    <span class="text-xs text-gray-400 text-center leading-tight" style="font-size:9px">{{ $d['date'] }}</span>
                </div>
                @endforeach
            </div>
        </div>
        <div class="flex items-center gap-4 mt-3 text-xs text-gray-500">
            <span class="flex items-center gap-1"><span class="h-2 w-4 bg-blue-400 rounded inline-block"></span> Creados</span>
            <span class="flex items-center gap-1"><span class="h-2 w-4 bg-green-400 rounded inline-block"></span> Cerrados</span>
        </div>
    </div>

    {{-- Por prioridad --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Por prioridad</h3>
        <div class="space-y-3">
            @foreach($byPriority as $name => $data)
            @php $pct = $metrics['total'] > 0 ? round(($data['count']/$metrics['total'])*100) : 0 @endphp
            <div>
                <div class="flex justify-between text-xs mb-1">
                    <span class="text-gray-600">{{ $name }}</span>
                    <span class="font-semibold" style="color: {{ $data['color'] }}">{{ $data['count'] }}</span>
                </div>
                <div class="h-2 bg-gray-100 rounded-full overflow-hidden">
                    <div class="h-full rounded-full" style="width:{{ $pct }}%; background-color: {{ $data['color'] }}"></div>
                </div>
            </div>
            @endforeach
        </div>
    </div>

</div>

{{-- Por agente --}}
@if($byAgent->count() > 0)
<div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-6">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-sm font-semibold text-gray-900">Productividad por agente</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Agente</th>
                    <th class="px-6 py-3 text-center text-xs font-semibold text-gray-500 uppercase">Total</th>
                    <th class="px-6 py-3 text-center text-xs font-semibold text-gray-500 uppercase">Resueltos</th>
                    <th class="px-6 py-3 text-center text-xs font-semibold text-gray-500 uppercase">SLA Breach</th>
                    <th class="px-6 py-3 text-center text-xs font-semibold text-gray-500 uppercase">Satisfacción</th>
                    <th class="px-6 py-3 text-center text-xs font-semibold text-gray-500 uppercase">% Resolución</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @foreach($byAgent as $name => $data)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-3 text-sm font-medium text-gray-900">{{ $name }}</td>
                    <td class="px-6 py-3 text-center text-sm text-gray-700">{{ $data['total'] }}</td>
                    <td class="px-6 py-3 text-center text-sm text-green-600 font-medium">{{ $data['closed'] }}</td>
                    <td class="px-6 py-3 text-center text-sm {{ $data['breached'] > 0 ? 'text-red-600 font-medium' : 'text-gray-400' }}">
                        {{ $data['breached'] ?: '—' }}
                    </td>
                    <td class="px-6 py-3 text-center text-sm text-yellow-600">
                        {{ $data['avg_sat'] ? $data['avg_sat'].'/5' : '—' }}
                    </td>
                    <td class="px-6 py-3 text-center text-sm">
                        @php $pct = $data['total'] > 0 ? round(($data['closed']/$data['total'])*100) : 0 @endphp
                        <div class="flex items-center gap-2">
                            <div class="flex-1 h-1.5 bg-gray-100 rounded-full">
                                <div class="h-full bg-blue-500 rounded-full" style="width:{{ $pct }}%"></div>
                            </div>
                            <span class="text-xs text-gray-600 w-8">{{ $pct }}%</span>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif

{{-- Tabla de tickets --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="px-6 py-4 border-b border-gray-200 flex items-center justify-between">
        <h3 class="text-sm font-semibold text-gray-900">Detalle de tickets ({{ $tickets->count() }})</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Número</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Título</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Prioridad</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Agente</th>
                    <th class="px-4 py-3 text-center text-xs font-semibold text-gray-500 uppercase">SLA</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Creado</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($tickets->take(50) as $ticket)
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-3">
                        <a href="{{ route('tickets.show', $ticket) }}"
                           class="text-sm font-mono text-blue-600 hover:underline">{{ $ticket->number }}</a>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-800 max-w-xs truncate">{{ $ticket->title }}</td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                              style="background-color: {{ $ticket->status->color }}20; color: {{ $ticket->status->color }}">
                            {{ $ticket->status->name }}
                        </span>
                    </td>
                    <td class="px-4 py-3">
                        <span class="text-xs font-medium" style="color: {{ $ticket->priority->color }}">
                            {{ $ticket->priority->name }}
                        </span>
                    </td>
                    <td class="px-4 py-3 text-sm text-gray-600">{{ $ticket->assignee?->name ?? '—' }}</td>
                    <td class="px-4 py-3 text-center">
                        @if($ticket->sla_resolution_breached)
                        <span class="text-xs text-red-500 font-medium">⚠ Breach</span>
                        @else
                        <span class="text-xs text-green-500">✓</span>
                        @endif
                    </td>
                    <td class="px-4 py-3 text-xs text-gray-500">{{ $ticket->created_at->format('d/m/y H:i') }}</td>
                </tr>
                @empty
                <tr><td colspan="7" class="px-4 py-8 text-center text-gray-400 text-sm">Sin tickets en este período.</td></tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($tickets->count() > 50)
    <div class="px-6 py-3 border-t border-gray-200 text-xs text-gray-400 text-center">
        Mostrando primeros 50 de {{ $tickets->count() }}. Usa exportar CSV para ver todos.
    </div>
    @endif
</div>
@endsection
