@extends('layouts.app')
@section('title', 'Tickets')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Tickets</h1>
        <p class="text-sm text-gray-500 mt-1">Centro de gestión de solicitudes</p>
    </div>
    <div class="flex gap-3">
        @if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte','agente']))
        <a href="{{ route('tickets.kanban') }}"
           class="inline-flex items-center px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
            <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17V7m0 10a2 2 0 01-2 2H5a2 2 0 01-2-2V7a2 2 0 012-2h2a2 2 0 012 2m0 10a2 2 0 002 2h2a2 2 0 002-2M9 7a2 2 0 012-2h2a2 2 0 012 2m0 10V7"/>
            </svg>
            Kanban
        </a>
        @endif
        <a href="{{ route('tickets.create') }}"
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Nuevo Ticket
        </a>
    </div>
</div>

{{-- Estadísticas rápidas --}}
<div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
    @foreach(\App\Models\TicketStatus::active()->withCount('tickets')->get() as $status)
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <p class="text-xs text-gray-500 font-medium uppercase tracking-wide">{{ $status->name }}</p>
        <p class="text-2xl font-bold mt-1" style="color: {{ $status->color }}">{{ $status->tickets_count }}</p>
    </div>
    @endforeach
</div>

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <livewire:tickets.ticket-table />
</div>
@endsection
