@extends('layouts.app')
@section('title', 'Kanban')
@section('content')
<div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Vista Kanban</h1>
    <div class="flex gap-3">
        <a href="{{ route('tickets.index') }}"
           class="px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
            Vista Lista
        </a>
        <a href="{{ route('tickets.create') }}"
           class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            + Nuevo Ticket
        </a>
    </div>
</div>

<div class="flex gap-4 overflow-x-auto pb-6">
    @foreach($statuses as $status)
    <div class="flex-shrink-0 w-72">
        {{-- Cabecera columna --}}
        <div class="flex items-center justify-between mb-3 px-1">
            <div class="flex items-center gap-2">
                <div class="h-3 w-3 rounded-full" style="background-color: {{ $status->color }}"></div>
                <span class="text-sm font-semibold text-gray-700">{{ $status->name }}</span>
                <span class="text-xs bg-gray-200 text-gray-600 px-2 py-0.5 rounded-full">
                    {{ $status->tickets->count() }}
                </span>
            </div>
        </div>

        {{-- Tarjetas --}}
        <div class="space-y-3">
            @forelse($status->tickets as $ticket)
            <a href="{{ route('tickets.show', $ticket) }}"
               class="block bg-white rounded-xl border border-gray-200 p-4 hover:shadow-md hover:border-blue-300 transition cursor-pointer">
                <div class="flex items-center justify-between mb-2">
                    <span class="text-xs font-mono text-blue-600 font-semibold">{{ $ticket->number }}</span>
                    <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                          style="background-color: {{ $ticket->priority->color }}20; color: {{ $ticket->priority->color }}">
                        {{ $ticket->priority->name }}
                    </span>
                </div>
                <p class="text-sm font-medium text-gray-900 line-clamp-2 mb-3">{{ $ticket->title }}</p>
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-1.5">
                        <img src="{{ $ticket->requester->avatar_url }}" class="h-5 w-5 rounded-full">
                        <span class="text-xs text-gray-500 truncate max-w-20">{{ $ticket->requester->name }}</span>
                    </div>
                    @php $sla = $ticket->sla_status @endphp
                    @if($sla === 'breached')
                    <span class="text-xs text-red-500 font-medium">⚠ SLA</span>
                    @elseif($sla === 'warning')
                    <span class="text-xs text-yellow-500">⏰</span>
                    @elseif($sla === 'ok')
                    <span class="text-xs text-green-500">✓</span>
                    @endif
                </div>
                @if($ticket->assignee)
                <div class="mt-2 pt-2 border-t border-gray-100 flex items-center gap-1.5">
                    <img src="{{ $ticket->assignee->avatar_url }}" class="h-5 w-5 rounded-full">
                    <span class="text-xs text-gray-400">{{ $ticket->assignee->name }}</span>
                </div>
                @endif
            </a>
            @empty
            <div class="bg-gray-50 rounded-xl border-2 border-dashed border-gray-200 p-6 text-center text-xs text-gray-400">
                Sin tickets
            </div>
            @endforelse
        </div>
    </div>
    @endforeach
</div>
@endsection
