@extends('layouts.app')
@section('title', 'Usuarios')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Usuarios</h1>
        <p class="text-sm text-gray-500 mt-1">Gestión de usuarios y accesos del sistema</p>
    </div>
    @can('users.create')
    <a href="{{ route('usuarios.create') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nuevo Usuario
    </a>
    @endcan
</div>
<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <livewire:users.user-table />
</div>
@endsection
