<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\TicketApiController;
use App\Http\Controllers\Api\AssetApiController;
use App\Http\Controllers\Api\KbApiController;
use App\Http\Controllers\Api\UserApiController;
use App\Http\Controllers\Api\ReportApiController;

Route::prefix('v1')->name('api.')->group(function () {

    Route::middleware('throttle:auth')->prefix('auth')->name('auth.')->group(function () {
        Route::post('login', [AuthController::class, 'login'])->name('login');
    });

    Route::middleware(['auth:sanctum','throttle:api'])->group(function () {

        Route::prefix('auth')->name('auth.')->group(function () {
            Route::get('me',          [AuthController::class, 'me'])->name('me');
            Route::get('tokens',      [AuthController::class, 'tokens'])->name('tokens');
            Route::post('logout',     [AuthController::class, 'logout'])->name('logout');
            Route::post('logout-all', [AuthController::class, 'logoutAll'])->name('logout-all');
        });

        Route::prefix('tickets')->name('tickets.')->group(function () {
            Route::get('stats',              [TicketApiController::class, 'stats'])->name('stats');
            Route::get('/',                  [TicketApiController::class, 'index'])->name('index');
            Route::post('/',                 [TicketApiController::class, 'store'])->name('store');
            Route::get('{ticket}',           [TicketApiController::class, 'show'])->name('show');
            Route::patch('{ticket}',         [TicketApiController::class, 'update'])->name('update');
            Route::post('{ticket}/comments', [TicketApiController::class, 'addComment'])->name('comment');
        });

        Route::prefix('assets')->name('assets.')->group(function () {
            Route::get('/',              [AssetApiController::class, 'index'])->name('index');
            Route::get('by-code/{code}',[AssetApiController::class, 'byCode'])->name('by-code');
            Route::get('{asset}',        [AssetApiController::class, 'show'])->name('show');
        });

        Route::prefix('kb')->name('kb.')->group(function () {
            Route::get('categories', [KbApiController::class, 'categories'])->name('categories');
            Route::get('search',     [KbApiController::class, 'search'])->name('search');
            Route::get('/',          [KbApiController::class, 'index'])->name('index');
            Route::get('{slug}',     [KbApiController::class, 'show'])->name('show');
        });

        Route::prefix('users')->name('users.')->group(function () {
            Route::get('agents', [UserApiController::class, 'agents'])->name('agents');
            Route::get('/',      [UserApiController::class, 'index'])->name('index');
        });

        Route::prefix('reports')->name('reports.')->middleware('throttle:strict')->group(function () {
            Route::get('summary', [ReportApiController::class, 'summary'])->name('summary');
            Route::get('sla',     [ReportApiController::class, 'sla'])->name('sla');
        });
    });
});

Route::fallback(fn() => response()->json(['success'=>false,'message'=>'Endpoint no encontrado.','docs'=>url('/api/docs')], 404));
