<?php $__env->startSection('title', 'Reportes'); ?>
<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Reportes y Exportaciones</h1>
    <p class="text-sm text-gray-500 mt-1">Análisis de desempeño y exportación de datos</p>
</div>

<div class="grid grid-cols-1 md:grid-cols-3 gap-5">

    
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition">
        <div class="h-10 w-10 bg-blue-50 rounded-xl flex items-center justify-center mb-4">
            <svg class="h-5 w-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"/>
            </svg>
        </div>
        <h3 class="text-base font-semibold text-gray-900 mb-1">Reporte de Tickets</h3>
        <p class="text-sm text-gray-500 mb-4">
            Análisis por período: volumen, distribución por prioridad/estado/agente, tendencia diaria.
        </p>
        <a href="<?php echo e(route('reports.tickets')); ?>"
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Ver reporte
        </a>
    </div>

    
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition">
        <div class="h-10 w-10 bg-green-50 rounded-xl flex items-center justify-center mb-4">
            <svg class="h-5 w-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
        </div>
        <h3 class="text-base font-semibold text-gray-900 mb-1">Cumplimiento SLA</h3>
        <p class="text-sm text-gray-500 mb-4">
            Cumplimiento por prioridad, tickets en breach activo y próximos a vencer.
        </p>
        <a href="<?php echo e(route('reports.sla')); ?>"
           class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-lg hover:bg-green-700 transition">
            Ver reporte
        </a>
    </div>

    
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6 hover:shadow-md transition">
        <div class="h-10 w-10 bg-purple-50 rounded-xl flex items-center justify-center mb-4">
            <svg class="h-5 w-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
            </svg>
        </div>
        <h3 class="text-base font-semibold text-gray-900 mb-1">Inventario CMDB</h3>
        <p class="text-sm text-gray-500 mb-4">
            Estado del inventario por categoría, valor total, garantías y activos asignados.
        </p>
        <a href="<?php echo e(route('reports.inventory')); ?>"
           class="inline-flex items-center px-4 py-2 bg-purple-600 text-white text-sm font-medium rounded-lg hover:bg-purple-700 transition">
            Ver reporte
        </a>
    </div>

</div>


<div class="mt-8">
    <h2 class="text-sm font-semibold text-gray-700 uppercase tracking-wide mb-4">Exportaciones rápidas</h2>
    <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
        <a href="<?php echo e(route('reports.export.tickets.csv', ['from' => now()->startOfMonth()->format('Y-m-d'), 'to' => now()->format('Y-m-d')])); ?>"
           class="flex items-center gap-3 p-4 bg-white rounded-xl border border-gray-200 hover:border-blue-300 hover:shadow-sm transition">
            <div class="h-9 w-9 bg-green-50 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg class="h-5 w-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-900">Tickets CSV</p>
                <p class="text-xs text-gray-400">Mes actual</p>
            </div>
        </a>
        <a href="<?php echo e(route('reports.export.tickets.pdf', ['from' => now()->startOfMonth()->format('Y-m-d'), 'to' => now()->format('Y-m-d')])); ?>"
           class="flex items-center gap-3 p-4 bg-white rounded-xl border border-gray-200 hover:border-red-300 hover:shadow-sm transition">
            <div class="h-9 w-9 bg-red-50 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg class="h-5 w-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                </svg>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-900">Tickets PDF</p>
                <p class="text-xs text-gray-400">Mes actual</p>
            </div>
        </a>
        <a href="<?php echo e(route('reports.export.inventory.csv')); ?>"
           class="flex items-center gap-3 p-4 bg-white rounded-xl border border-gray-200 hover:border-green-300 hover:shadow-sm transition">
            <div class="h-9 w-9 bg-green-50 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg class="h-5 w-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-900">Inventario CSV</p>
                <p class="text-xs text-gray-400">Todos los activos</p>
            </div>
        </a>
        <a href="<?php echo e(route('reports.export.inventory.pdf')); ?>"
           class="flex items-center gap-3 p-4 bg-white rounded-xl border border-gray-200 hover:border-red-300 hover:shadow-sm transition">
            <div class="h-9 w-9 bg-red-50 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg class="h-5 w-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                </svg>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-900">Inventario PDF</p>
                <p class="text-xs text-gray-400">Todos los activos</p>
            </div>
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/reports/index.blade.php ENDPATH**/ ?>