<?php $__env->startSection('title', 'Auditoría'); ?>
<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Auditoría del Sistema</h1>
    <p class="text-sm text-gray-500 mt-1">Registro completo de actividad</p>
</div>

<?php
    $logs = \Spatie\Activitylog\Models\Activity::with('causer')
        ->latest()
        ->paginate(25);
?>

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Fecha</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Usuario</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Acción</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Descripción</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 text-xs text-gray-500 whitespace-nowrap">
                        <?php echo e($log->created_at->format('d/m/Y H:i')); ?>

                    </td>
                    <td class="px-6 py-4 text-sm text-gray-700">
                        <?php echo e($log->causer?->name ?? 'Sistema'); ?>

                    </td>
                    <td class="px-6 py-4">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                            <?php echo e($log->event === 'created' ? 'bg-green-100 text-green-800' :
                               ($log->event === 'updated' ? 'bg-blue-100 text-blue-800' :
                               ($log->event === 'deleted' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800'))); ?>">
                            <?php echo e(ucfirst($log->event ?? 'evento')); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600">
                        <?php echo e($log->description); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="px-6 py-12 text-center text-gray-400 text-sm">
                        No hay registros de actividad aún.
                    </td>
                </tr>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($logs->hasPages()): ?>
    <div class="px-6 py-4 border-t border-gray-200">
        <?php echo e($logs->links()); ?>

    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/admin/activity-log.blade.php ENDPATH**/ ?>