<?php $__env->startSection('title', 'Automatizaciones'); ?>
<?php $__env->startSection('content'); ?>

<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
<div class="mb-4 p-3 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm">✓ <?php echo e(session('success')); ?></div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Reglas de Automatización</h1>
        <p class="text-sm text-gray-500 mt-1">Acciones automáticas basadas en eventos de tickets</p>
    </div>
    <a href="<?php echo e(route('admin.automations.create')); ?>"
       class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        + Nueva regla
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
<div class="lg:col-span-2">


<div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="p-5 flex items-start gap-4">
        <div class="flex-shrink-0 mt-0.5">
            <span class="h-3 w-3 rounded-full inline-block <?php echo e($rule->active ? 'bg-green-500' : 'bg-gray-300'); ?>"></span>
        </div>
        <div class="flex-1 min-w-0">
            <div class="flex items-center gap-2 mb-1">
                <h3 class="text-sm font-semibold text-gray-900"><?php echo e($rule->name); ?></h3>
                <span class="text-xs px-2 py-0.5 rounded-full bg-blue-100 text-blue-700">
                    <?php echo e(\App\Models\AutomationRule::$triggers[$rule->trigger] ?? $rule->trigger); ?>

                </span>
            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($rule->description): ?>
            <p class="text-xs text-gray-500 mb-2"><?php echo e($rule->description); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <div class="flex items-center gap-4 text-xs text-gray-400">
                <span><?php echo e(count($rule->conditions)); ?> condicion(es)</span>
                <span><?php echo e(count($rule->actions)); ?> acción(es)</span>
                <span><?php echo e($rule->executions); ?> ejecuciones</span>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($rule->last_executed_at): ?>
                <span>Última: <?php echo e($rule->last_executed_at->diffForHumans()); ?></span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
        <div class="flex items-center gap-2 flex-shrink-0">
            <form method="POST" action="<?php echo e(route('admin.automations.toggle', $rule)); ?>">
                <?php echo csrf_field(); ?> <?php echo method_field('PATCH'); ?>
                <button type="submit"
                        class="px-2.5 py-1 text-xs rounded-lg <?php echo e($rule->active ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-500'); ?> hover:opacity-80 transition">
                    <?php echo e($rule->active ? 'Activa' : 'Inactiva'); ?>

                </button>
            </form>
            <a href="<?php echo e(route('admin.automations.edit', $rule)); ?>"
               class="px-2.5 py-1 text-xs bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition">
                Editar
            </a>
            <form method="POST" action="<?php echo e(route('admin.automations.destroy', $rule)); ?>"
                  onsubmit="return confirm('¿Eliminar esta regla?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-2.5 py-1 text-xs bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition">
                    ✕
                </button>
            </form>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="p-12 text-center text-gray-400 text-sm">
        No hay reglas de automatización.
        <a href="<?php echo e(route('admin.automations.create')); ?>" class="text-blue-600 hover:underline">Crear la primera</a>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

</div>


<div>
    <h3 class="text-sm font-semibold text-gray-700 mb-3">Ejecuciones recientes</h3>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $recentLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="px-4 py-3">
            <div class="flex items-center justify-between mb-0.5">
                <span class="text-xs font-medium text-gray-900 truncate max-w-36"><?php echo e($log->rule->name); ?></span>
                <span class="text-xs <?php echo e($log->result === 'success' ? 'text-green-600' : 'text-red-500'); ?>">
                    <?php echo e($log->result === 'success' ? '✓' : '✗'); ?>

                </span>
            </div>
            <p class="text-xs text-gray-500">
                <a href="<?php echo e(route('tickets.show', $log->ticket)); ?>" class="text-blue-600 hover:underline">
                    <?php echo e($log->ticket->number); ?>

                </a>
                · <?php echo e($log->executed_at->diffForHumans()); ?>

            </p>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="p-6 text-center text-gray-400 text-xs">Sin ejecuciones aún</div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/admin/automations/index.blade.php ENDPATH**/ ?>