<?php $__env->startSection('title', 'IA — Clasificación Automática'); ?>
<?php $__env->startSection('content'); ?>

<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">🤖 IA — Clasificación Automática</h1>
    <p class="text-sm text-gray-500 mt-1">Motor de clasificación local por palabras clave ponderadas</p>
</div>

<div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = [
        ['Total clasificaciones', $totalClassifications, 'text-blue-700','🎫'],
        ['Sugerencias aceptadas', $accepted,             'text-green-700','✓'],
        ['Precisión estimada',    $accuracy.'%',         'text-purple-700','🎯'],
        ['Confianza categoría',   $avgCatConfidence.'%', 'text-orange-700','📊'],
    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as [$label,$val,$color,$icon]): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="bg-white rounded-xl border border-gray-200 p-5">
        <p class="text-xs text-gray-500 mb-1"><?php echo e($icon); ?> <?php echo e($label); ?></p>
        <p class="text-2xl font-bold <?php echo e($color); ?>"><?php echo e($val); ?></p>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="p-5 border-b border-gray-100"><h2 class="text-sm font-semibold">Clasificaciones recientes</h2></div>
    <div class="divide-y divide-gray-100">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $recentClassifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="p-4">
            <div class="flex items-center justify-between mb-1">
                <a href="<?php echo e(route('tickets.show', $cl->ticket)); ?>" class="text-sm font-medium text-blue-600 hover:underline"><?php echo e($cl->ticket->number); ?></a>
                <span class="text-xs <?php echo e($cl->applied ? 'text-green-600' : 'text-gray-400'); ?>"><?php echo e($cl->applied ? '✓ Aceptada' : 'Pendiente'); ?></span>
            </div>
            <p class="text-xs text-gray-600 truncate mb-2"><?php echo e($cl->ticket->title); ?></p>
            <div class="flex flex-wrap gap-3 text-xs">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cl->suggestedCategory): ?><span class="text-blue-600">📁 <?php echo e($cl->suggestedCategory->name); ?> (<?php echo e($cl->category_confidence); ?>%)</span><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cl->suggestedPriority): ?><span class="text-orange-600">⚡ <?php echo e($cl->suggestedPriority->name); ?> (<?php echo e($cl->priority_confidence); ?>%)</span><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($cl->keywords_detected)): ?>
            <div class="flex flex-wrap gap-1 mt-1">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = array_slice($cl->keywords_detected,0,5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="text-xs bg-gray-100 text-gray-400 px-1 py-0.5 rounded"><?php echo e($kw); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="p-8 text-center text-gray-400 text-sm">Sin clasificaciones aún. Crea un ticket para empezar.</div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>

<div class="space-y-5">
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h2 class="text-sm font-semibold mb-4">Cómo funciona el motor</h2>
        <div class="space-y-2 text-sm text-gray-600">
            <p><span class="font-bold text-blue-600">1</span> — Extrae keywords del título y descripción del ticket</p>
            <p><span class="font-bold text-blue-600">2</span> — Elimina stopwords en español, genera bigramas</p>
            <p><span class="font-bold text-blue-600">3</span> — Compara contra reglas ponderadas en <code class="font-mono text-xs bg-gray-100 px-1 rounded">ai_keyword_rules</code></p>
            <p><span class="font-bold text-blue-600">4</span> — La categoría/prioridad con mayor score acumulado gana</p>
            <p><span class="font-bold text-blue-600">5</span> — ✓ Aceptar: peso +0.1 · ✗ Rechazar: peso -0.15 y aprende corrección</p>
            <p><span class="font-bold text-blue-600">6</span> — Artículos KB rankeados por coincidencia + popularidad + helpful rate</p>
        </div>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h2 class="text-sm font-semibold mb-3">Acciones de mantenimiento</h2>
        <button onclick="retrain()" class="w-full py-2 text-sm bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition mb-2">
            🔄 Re-entrenar con tickets históricos
        </button>
        <a href="<?php echo e(route('ai.kb-drafts')); ?>" class="block w-full py-2 text-sm text-center bg-green-600 text-white rounded-lg hover:bg-green-700 transition mb-2">
            📝 Borradores KB pendientes
        </a>
        <a href="<?php echo e(route('ai.templates')); ?>" class="block w-full py-2 text-sm text-center bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition mb-2">
            ⚡ Plantillas de respuesta
        </a>
        <a href="<?php echo e(route('admin.settings.index')); ?>" class="block w-full py-2 text-sm text-center bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition">
            ⚙️ Configuración
        </a>
        <div id="retrain-result" class="mt-3 text-xs text-gray-500 hidden"></div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>
<script>
function retrain() {
    const btn = event.target;
    btn.disabled = true; btn.textContent = 'Entrenando...';
    fetch('/ai/retrain', {
        method:'POST',
        headers:{'Content-Type':'application/json','X-CSRF-TOKEN':document.querySelector('meta[name="csrf-token"]').content}
    }).then(r=>r.json()).then(d=>{
        btn.disabled=false; btn.textContent='🔄 Re-entrenar con tickets históricos';
        const el=document.getElementById('retrain-result');
        el.textContent=d.message; el.classList.remove('hidden');
    }).catch(()=>{ btn.disabled=false; btn.textContent='🔄 Re-entrenar con tickets históricos'; });
}
</script>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/ai/admin.blade.php ENDPATH**/ ?>