<div>
    
    <div class="p-4 border-b border-gray-200 bg-gray-50 rounded-t-xl">
        <div class="grid grid-cols-2 md:grid-cols-5 gap-3">
            <div class="col-span-2">
                <input wire:model.live.debounce.300ms="search" type="text"
                       placeholder="Buscar por número, título o solicitante..."
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <select wire:model.live="filterStatus"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los estados</option>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \App\Models\TicketStatus::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </select>
            <select wire:model.live="filterPriority"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todas las prioridades</option>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \App\Models\TicketPriority::active()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($p->id); ?>"><?php echo e($p->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </select>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte'])): ?>
            <select wire:model.live="filterAgent"
                    class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <option value="">Todos los agentes</option>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = \App\Models\User::active()->agents()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($a->id); ?>"><?php echo e($a->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </select>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
        <?php if(auth()->user()->hasAnyRole(['admin','superadmin','jefe_soporte','agente'])): ?>
        <div class="mt-2 flex gap-3">
            <label class="flex items-center gap-2 text-sm text-gray-600 cursor-pointer">
                <input type="checkbox" wire:model.live="filterMine" value="1"
                       class="rounded border-gray-300 text-blue-600">
                Solo mis tickets
            </label>
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Número</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Título</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Prioridad</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-32">Estado</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-36">SLA</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-36">Agente</th>
                    <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase w-28">Creado</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50 cursor-pointer transition"
                    onclick="window.location='<?php echo e(route('tickets.show', $ticket)); ?>'">
                    <td class="px-4 py-3">
                        <span class="text-sm font-mono font-semibold text-blue-600"><?php echo e($ticket->number); ?></span>
                    </td>
                    <td class="px-4 py-3">
                        <p class="text-sm font-medium text-gray-900 line-clamp-1"><?php echo e($ticket->title); ?></p>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($ticket->category): ?>
                        <p class="text-xs text-gray-400 mt-0.5"><?php echo e($ticket->category->name); ?></p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                              style="background-color: <?php echo e($ticket->priority->color); ?>20; color: <?php echo e($ticket->priority->color); ?>">
                            <?php echo e($ticket->priority->name); ?>

                        </span>
                    </td>
                    <td class="px-4 py-3">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium"
                              style="background-color: <?php echo e($ticket->status->color); ?>20; color: <?php echo e($ticket->status->color); ?>">
                            <?php echo e($ticket->status->name); ?>

                        </span>
                    </td>
                    <td class="px-4 py-3">
                        <?php $sla = $ticket->sla_status ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sla === 'breached'): ?>
                        <span class="text-xs text-red-600 font-medium">⚠ <?php echo e($ticket->sla_remaining); ?></span>
                        <?php elseif($sla === 'warning'): ?>
                        <span class="text-xs text-yellow-600 font-medium">⏰ <?php echo e($ticket->sla_remaining); ?></span>
                        <?php elseif($sla === 'ok'): ?>
                        <span class="text-xs text-green-600">✓ <?php echo e($ticket->sla_remaining); ?></span>
                        <?php else: ?>
                        <span class="text-xs text-gray-400">—</span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </td>
                    <td class="px-4 py-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($ticket->assignee): ?>
                        <div class="flex items-center gap-2">
                            <img src="<?php echo e($ticket->assignee->avatar_url); ?>" class="h-6 w-6 rounded-full">
                            <span class="text-xs text-gray-700"><?php echo e($ticket->assignee->name); ?></span>
                        </div>
                        <?php else: ?>
                        <span class="text-xs text-red-500 font-medium">Sin asignar</span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </td>
                    <td class="px-4 py-3 text-xs text-gray-500">
                        <?php echo e($ticket->created_at->format('d/m/y H:i')); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="px-4 py-12 text-center text-gray-400 text-sm">
                        No se encontraron tickets con los filtros aplicados.
                    </td>
                </tr>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tickets->hasPages()): ?>
    <div class="px-6 py-4 border-t border-gray-200"><?php echo e($tickets->links()); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/livewire/tickets/ticket-table.blade.php ENDPATH**/ ?>