<?php $__env->startSection('title', 'Inventario'); ?>
<?php $__env->startSection('content'); ?>
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Inventario de Activos</h1>
        <p class="text-sm text-gray-500 mt-1">CMDB — Configuration Management Database</p>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('assets.create')): ?>
    <a href="<?php echo e(route('assets.create')); ?>"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nuevo Activo
    </a>
    <?php endif; ?>
</div>


<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4 mb-6">
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="bg-white rounded-xl border border-gray-200 p-4">
        <div class="h-8 w-8 rounded-lg mb-2 flex items-center justify-center"
             style="background-color: <?php echo e($cat->color); ?>20;">
            <div class="h-3 w-3 rounded-full" style="background-color: <?php echo e($cat->color); ?>"></div>
        </div>
        <p class="text-xs text-gray-500 font-medium truncate"><?php echo e($cat->name); ?></p>
        <p class="text-xl font-bold text-gray-900 mt-0.5"><?php echo e($cat->assets_count); ?></p>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>


<?php
    $expiringWarranty = \App\Models\Asset::whereNotNull('warranty_until')
        ->where('warranty_until', '>', now())
        ->where('warranty_until', '<=', now()->addDays(30))
        ->count();
?>
<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($expiringWarranty > 0): ?>
<div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4 mb-5 flex items-center gap-3">
    <span class="text-yellow-500 text-lg">⚠</span>
    <p class="text-sm text-yellow-800">
        <strong><?php echo e($expiringWarranty); ?> activo(s)</strong> con garantía próxima a vencer (próximos 30 días).
    </p>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('assets.asset-table', []);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2473172385-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/assets/index.blade.php ENDPATH**/ ?>