<?php $__env->startSection('title', 'Base de Conocimiento'); ?>
<?php $__env->startSection('content'); ?>


<div class="bg-gradient-to-br from-blue-700 to-blue-900 rounded-2xl px-8 py-10 mb-8 text-center">
    <h1 class="text-3xl font-bold text-white mb-2">Base de Conocimiento</h1>
    <p class="text-blue-200 mb-6 text-sm">Encuentra guías, tutoriales y soluciones a problemas frecuentes</p>
    <form method="GET" class="max-w-xl mx-auto">
        <div class="flex gap-2">
            <input type="text" name="q" value="<?php echo e($query); ?>"
                   placeholder="¿En qué te puedo ayudar? Ej: resetear contraseña, configurar correo..."
                   class="flex-1 rounded-xl border-0 px-4 py-3 text-sm text-gray-900 focus:ring-2 focus:ring-blue-300">
            <button type="submit"
                    class="px-5 py-3 bg-white text-blue-700 font-semibold text-sm rounded-xl hover:bg-blue-50 transition">
                Buscar
            </button>
        </div>
    </form>
</div>


<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($query): ?>
<div class="mb-8">
    <div class="flex items-center gap-3 mb-4">
        <h2 class="text-lg font-semibold text-gray-900">
            Resultados para "<?php echo e($query); ?>"
        </h2>
        <a href="<?php echo e(route('kb.index')); ?>" class="text-sm text-blue-600 hover:underline">Limpiar</a>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($articles->count() > 0): ?>
    <div class="space-y-3">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('kb.show', $article->slug)); ?>"
           class="block bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md hover:border-blue-300 transition">
            <div class="flex items-start justify-between gap-4">
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-900 mb-1"><?php echo e($article->title); ?></h3>
                    <p class="text-xs text-gray-500 line-clamp-2"><?php echo e($article->excerpt); ?></p>
                    <div class="flex items-center gap-3 mt-2">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($article->category): ?>
                        <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                              style="background-color: <?php echo e($article->category->color); ?>20; color: <?php echo e($article->category->color); ?>">
                            <?php echo e($article->category->name); ?>

                        </span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <span class="text-xs text-gray-400"><?php echo e($article->views); ?> vistas</span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($article->helpful_rate !== null): ?>
                        <span class="text-xs text-green-600">👍 <?php echo e($article->helpful_rate); ?>% útil</span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
                <svg class="h-4 w-4 text-gray-400 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    <div class="mt-4"><?php echo e($articles->links()); ?></div>
    <?php else: ?>
    <div class="bg-gray-50 rounded-xl p-8 text-center">
        <p class="text-gray-500 text-sm mb-3">No encontramos artículos para "<?php echo e($query); ?>"</p>
        <a href="<?php echo e(route('tickets.create')); ?>"
           class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Crear un ticket de soporte
        </a>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>
<?php else: ?>


<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($featured->count() > 0): ?>
<div class="mb-8">
    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-4">Artículos destacados</h2>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('kb.show', $article->slug)); ?>"
           class="block bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
            <div class="flex items-center gap-2 mb-2">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($article->category): ?>
                <span class="text-xs px-2 py-0.5 rounded-full font-medium"
                      style="background-color: <?php echo e($article->category->color); ?>20; color: <?php echo e($article->category->color); ?>">
                    <?php echo e($article->category->name); ?>

                </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <span class="text-xs text-yellow-500">⭐ Destacado</span>
            </div>
            <h3 class="text-sm font-semibold text-gray-900 mb-1"><?php echo e($article->title); ?></h3>
            <p class="text-xs text-gray-500 line-clamp-2"><?php echo e($article->excerpt); ?></p>
            <div class="flex items-center gap-3 mt-3 text-xs text-gray-400">
                <span><?php echo e($article->views); ?> vistas</span>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($article->helpful_rate !== null): ?>
                <span class="text-green-600">👍 <?php echo e($article->helpful_rate); ?>%</span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-5 mb-8">
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->articles_count > 0 || $category->children->count() > 0): ?>
    <div class="bg-white rounded-xl border border-gray-200 p-5 hover:shadow-md transition">
        <a href="<?php echo e(route('kb.category', $category->slug)); ?>" class="block">
            <div class="flex items-center gap-3 mb-3">
                <div class="h-10 w-10 rounded-xl flex items-center justify-center"
                     style="background-color: <?php echo e($category->color); ?>20;">
                    <div class="h-4 w-4 rounded-full" style="background-color: <?php echo e($category->color); ?>"></div>
                </div>
                <div>
                    <h3 class="text-sm font-semibold text-gray-900"><?php echo e($category->name); ?></h3>
                    <p class="text-xs text-gray-400"><?php echo e($category->articles_count); ?> artículo(s)</p>
                </div>
            </div>
        </a>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->description): ?>
        <p class="text-xs text-gray-500 mb-3"><?php echo e($category->description); ?></p>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        <div class="space-y-1.5">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $category->articles->where('status','published')->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $art): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('kb.show', $art->slug)); ?>"
               class="block text-xs text-blue-600 hover:text-blue-800 hover:underline truncate">
                → <?php echo e($art->title); ?>

            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>


<?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($recent->count() > 0): ?>
<div>
    <h2 class="text-sm font-semibold text-gray-500 uppercase tracking-wide mb-4">Publicados recientemente</h2>
    <div class="bg-white rounded-xl border border-gray-200 divide-y divide-gray-100">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $recent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('kb.show', $article->slug)); ?>"
           class="flex items-center gap-4 px-5 py-3 hover:bg-gray-50 transition">
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium text-gray-900 truncate"><?php echo e($article->title); ?></p>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($article->category): ?>
                <p class="text-xs text-gray-400 mt-0.5"><?php echo e($article->category->name); ?></p>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <span class="text-xs text-gray-400 flex-shrink-0"><?php echo e($article->published_at?->format('d/m/y')); ?></span>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>
<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

<?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/evolucionamos/public_html/freddy/resources/views/kb/index.blade.php ENDPATH**/ ?>