<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

startSession();
requireRole(['admin']);

$page      = 'admin-audit';
$pageTitle = 'Registro de Auditoría';

$search = trim($_GET['q'] ?? '');
$entity = $_GET['entity'] ?? '';
$page_n = max(1, (int)($_GET['p'] ?? 1));
$perPage = 50;

$where  = ['1=1'];
$params = [];
if ($search) { $where[] = '(al.action LIKE ? OR u.name LIKE ? OR u.email LIKE ?)'; $params = array_merge($params, ["%$search%","%$search%","%$search%"]); }
if ($entity) { $where[] = 'al.entity=?'; $params[] = $entity; }
$whereStr = implode(' AND ', $where);

$total  = db()->fetchOne("SELECT COUNT(*) c FROM audit_log al LEFT JOIN users u ON al.user_id=u.id WHERE $whereStr", $params)['c'];
$offset = ($page_n - 1) * $perPage;
$pages  = ceil($total / $perPage);

$logs = db()->fetchAll(
    "SELECT al.*, u.name as user_name, u.email as user_email
     FROM audit_log al LEFT JOIN users u ON al.user_id=u.id
     WHERE $whereStr ORDER BY al.created_at DESC LIMIT $perPage OFFSET $offset", $params
);

require_once __DIR__ . '/../includes/header.php';
?>

<div class="card mb-3">
    <div class="card-body py-2">
        <form method="GET" class="row g-2">
            <div class="col"><input type="text" name="q" class="form-control form-control-sm" placeholder="🔍 Buscar acción o usuario..." value="<?= htmlspecialchars($search) ?>"></div>
            <div class="col-auto">
                <select name="entity" class="form-select form-select-sm">
                    <option value="">Todas las entidades</option>
                    <?php foreach (['tickets','users','assets','knowledge_base'] as $e): ?>
                    <option value="<?= $e ?>" <?= $entity===$e?'selected':'' ?>><?= ucfirst($e) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-auto"><button class="btn btn-sm btn-primary">Filtrar</button></div>
            <div class="col-auto ms-auto"><small class="text-muted"><?= $total ?> registros</small></div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0" style="font-size:.82rem;">
            <thead class="table-light">
                <tr><th>Fecha/Hora</th><th>Usuario</th><th>Acción</th><th>Entidad</th><th>ID</th><th>IP</th></tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $log): ?>
                <tr>
                    <td class="text-muted"><?= formatDate($log['created_at']) ?></td>
                    <td>
                        <?php if ($log['user_name']): ?>
                        <strong><?= sanitize($log['user_name']) ?></strong>
                        <small class="d-block text-muted"><?= sanitize($log['user_email']) ?></small>
                        <?php else: ?><span class="text-muted">Sistema</span><?php endif; ?>
                    </td>
                    <td><span class="badge bg-light text-dark border"><?= sanitize($log['action']) ?></span></td>
                    <td><?= sanitize($log['entity']) ?></td>
                    <td><?= $log['entity_id'] ?? '-' ?></td>
                    <td class="text-muted"><?= sanitize($log['ip_address'] ?? '-') ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($logs)): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">No hay registros de auditoría.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if ($pages > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php for ($i = 1; $i <= min($pages, 10); $i++): ?>
            <li class="page-item <?= $i===$page_n?'active':'' ?>">
                <a class="page-link" href="?p=<?= $i ?>&q=<?= urlencode($search) ?>&entity=<?= $entity ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
