<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

startSession();
requireRole(['admin']);

$page      = 'admin-cats';
$pageTitle = 'Gestión de Categorías';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'save') {
        $id = (int)($_POST['cat_id'] ?? 0);
        $data = [
            sanitize($_POST['name']),
            sanitize($_POST['description'] ?? ''),
            $_POST['color'] ?? '#3B82F6',
            sanitize($_POST['icon'] ?? 'bi-tag'),
            $_POST['parent_id'] ?: null,
            (int)($_POST['sla_hours'] ?? 24),
            isset($_POST['active']) ? 1 : 0,
        ];
        if ($id) {
            db()->execute("UPDATE categories SET name=?,description=?,color=?,icon=?,parent_id=?,sla_hours=?,active=? WHERE id=?",
                [...$data, $id]);
            flash('success', 'Categoría actualizada.');
        } else {
            db()->insert("INSERT INTO categories (name,description,color,icon,parent_id,sla_hours,active) VALUES (?,?,?,?,?,?,?)", $data);
            flash('success', 'Categoría creada.');
        }
    }
    if ($action === 'delete') {
        $id = (int)$_POST['cat_id'];
        db()->execute("UPDATE categories SET active=0 WHERE id=?", [$id]);
        flash('success', 'Categoría desactivada.');
    }
    header('Location: ' . BASE_URL . '/admin/categories.php');
    exit;
}

$parents  = db()->fetchAll("SELECT * FROM categories WHERE parent_id IS NULL ORDER BY name");
$allCats  = db()->fetchAll(
    "SELECT c.*, p.name as parent_name, (SELECT COUNT(*) FROM tickets WHERE category_id=c.id OR subcategory_id=c.id) as ticket_count
     FROM categories c LEFT JOIN categories p ON c.parent_id=p.id ORDER BY ISNULL(c.parent_id) DESC, p.name, c.name"
);

require_once __DIR__ . '/../includes/header.php';
?>

<?php if (flash('success')): ?>
<div class="alert alert-success"><i class="bi bi-check-circle me-2"></i><?= flash('success') ?></div>
<?php endif; ?>

<div class="d-flex justify-content-end mb-3">
    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#catModal">
        <i class="bi bi-plus me-1"></i>Nueva Categoría
    </button>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr><th>Nombre</th><th>Tipo</th><th>SLA (hrs)</th><th>Tickets</th><th>Estado</th><th>Acciones</th></tr>
            </thead>
            <tbody>
                <?php foreach ($allCats as $c): ?>
                <tr>
                    <td>
                        <?php if ($c['parent_id']): ?><span class="text-muted ms-3">↳ </span><?php endif; ?>
                        <span class="badge me-2" style="background:<?= $c['color'] ?>;font-size:.7rem;">
                            <i class="bi <?= $c['icon'] ?>"></i>
                        </span>
                        <strong><?= sanitize($c['name']) ?></strong>
                        <?php if ($c['description']): ?>
                        <small class="text-muted ms-2"><?= sanitize(substr($c['description'], 0, 50)) ?></small>
                        <?php endif; ?>
                    </td>
                    <td><small><?= $c['parent_id'] ? 'Subcategoría de: ' . sanitize($c['parent_name']) : '<strong>Principal</strong>' ?></small></td>
                    <td><span class="badge bg-light text-dark border"><?= $c['sla_hours'] ?>h</span></td>
                    <td><span class="badge bg-light text-dark border"><?= $c['ticket_count'] ?></span></td>
                    <td><span class="badge bg-<?= $c['active']?'success':'secondary' ?>"><?= $c['active']?'Activa':'Inactiva' ?></span></td>
                    <td>
                        <button class="btn btn-sm btn-outline-primary" onclick="editCat(<?= json_encode($c) ?>)"><i class="bi bi-pencil"></i></button>
                        <form method="POST" style="display:inline;" onsubmit="return confirm('¿Desactivar categoría?')">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="cat_id" value="<?= $c['id'] ?>">
                            <button type="submit" class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- MODAL -->
<div class="modal fade" id="catModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <input type="hidden" name="action" value="save">
                <input type="hidden" name="cat_id" id="catId" value="">
                <div class="modal-header">
                    <h5 class="modal-title" id="catModalTitle">Nueva Categoría</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3"><label class="form-label small fw-semibold">Nombre *</label>
                        <input type="text" name="name" id="c_name" class="form-control" required></div>
                    <div class="mb-3"><label class="form-label small fw-semibold">Descripción</label>
                        <input type="text" name="description" id="c_desc" class="form-control"></div>
                    <div class="row g-3 mb-3">
                        <div class="col"><label class="form-label small fw-semibold">Color</label>
                            <input type="color" name="color" id="c_color" class="form-control form-control-color" value="#3B82F6"></div>
                        <div class="col"><label class="form-label small fw-semibold">Icono Bootstrap</label>
                            <input type="text" name="icon" id="c_icon" class="form-control" placeholder="bi-tag" value="bi-tag"></div>
                        <div class="col"><label class="form-label small fw-semibold">SLA (horas)</label>
                            <input type="number" name="sla_hours" id="c_sla" class="form-control" value="24" min="1"></div>
                    </div>
                    <div class="mb-3"><label class="form-label small fw-semibold">Categoría padre (si es subcategoría)</label>
                        <select name="parent_id" id="c_parent" class="form-select">
                            <option value="">-- Es categoría principal --</option>
                            <?php foreach ($parents as $p): ?>
                            <option value="<?= $p['id'] ?>"><?= sanitize($p['name']) ?></option>
                            <?php endforeach; ?>
                        </select></div>
                    <div class="form-check">
                        <input type="checkbox" name="active" id="c_active" class="form-check-input" value="1" checked>
                        <label class="form-check-label small" for="c_active">Categoría activa</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$extraJs = '<script>
function editCat(c) {
    document.getElementById("catId").value = c.id;
    document.getElementById("catModalTitle").textContent = "Editar Categoría";
    document.getElementById("c_name").value = c.name;
    document.getElementById("c_desc").value = c.description || "";
    document.getElementById("c_color").value = c.color || "#3B82F6";
    document.getElementById("c_icon").value = c.icon || "bi-tag";
    document.getElementById("c_sla").value = c.sla_hours || 24;
    document.getElementById("c_parent").value = c.parent_id || "";
    document.getElementById("c_active").checked = c.active == 1;
    new bootstrap.Modal(document.getElementById("catModal")).show();
}
</script>';
require_once __DIR__ . '/../includes/footer.php';
?>
