<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

startSession();
requireRole(['admin','agent']);

$page      = 'admin-reports';
$pageTitle = 'Reportes y Métricas';

// Rango de fechas
$from = $_GET['from'] ?? date('Y-m-01');
$to   = $_GET['to']   ?? date('Y-m-d');

// KPIs
$totalTickets   = db()->fetchOne("SELECT COUNT(*) c FROM tickets WHERE DATE(created_at) BETWEEN ? AND ?", [$from, $to])['c'];
$resolvedTickets= db()->fetchOne("SELECT COUNT(*) c FROM tickets WHERE status IN ('resolved','closed') AND DATE(created_at) BETWEEN ? AND ?", [$from, $to])['c'];
$avgResolutionH = db()->fetchOne(
    "SELECT ROUND(AVG(TIMESTAMPDIFF(HOUR, created_at, resolved_at)),1) h FROM tickets WHERE resolved_at IS NOT NULL AND DATE(created_at) BETWEEN ? AND ?", [$from, $to]
)['h'] ?? 0;
$slaBreaches    = db()->fetchOne(
    "SELECT COUNT(*) c FROM tickets WHERE due_date < NOW() AND status NOT IN ('resolved','closed') AND DATE(created_at) BETWEEN ? AND ?", [$from, $to]
)['c'];
$satisfactionAvg= db()->fetchOne(
    "SELECT ROUND(AVG(satisfaction),1) s FROM tickets WHERE satisfaction IS NOT NULL AND DATE(created_at) BETWEEN ? AND ?", [$from, $to]
)['s'] ?? '-';

// Por estado
$byStatus    = db()->fetchAll("SELECT status, COUNT(*) c FROM tickets WHERE DATE(created_at) BETWEEN ? AND ? GROUP BY status", [$from, $to]);
$byPriority  = db()->fetchAll("SELECT priority, COUNT(*) c FROM tickets WHERE DATE(created_at) BETWEEN ? AND ? GROUP BY priority", [$from, $to]);
$byAgent     = db()->fetchAll(
    "SELECT u.name, COUNT(t.id) total, SUM(t.status IN ('resolved','closed')) resolved
     FROM tickets t JOIN users u ON t.agent_id=u.id
     WHERE DATE(t.created_at) BETWEEN ? AND ? GROUP BY t.agent_id ORDER BY total DESC", [$from, $to]
);
$byCategory  = db()->fetchAll(
    "SELECT c.name, COUNT(t.id) c FROM tickets t
     LEFT JOIN categories c ON t.category_id=c.id
     WHERE DATE(t.created_at) BETWEEN ? AND ? GROUP BY t.category_id ORDER BY c DESC LIMIT 8", [$from, $to]
);
// Tendencia diaria (últimos 30 días)
$dailyTrend = db()->fetchAll(
    "SELECT DATE(created_at) d, COUNT(*) c FROM tickets WHERE created_at >= DATE_SUB(NOW(), INTERVAL 30 DAY) GROUP BY DATE(created_at) ORDER BY d"
);

$resolutionRate = $totalTickets > 0 ? round($resolvedTickets / $totalTickets * 100, 1) : 0;

require_once __DIR__ . '/../includes/header.php';
?>

<!-- DATE FILTER -->
<div class="card mb-4">
    <div class="card-body py-2">
        <form method="GET" class="row g-2 align-items-center">
            <div class="col-auto"><label class="form-label mb-0 small">Desde</label></div>
            <div class="col-auto"><input type="date" name="from" value="<?= $from ?>" class="form-control form-control-sm"></div>
            <div class="col-auto"><label class="form-label mb-0 small">Hasta</label></div>
            <div class="col-auto"><input type="date" name="to" value="<?= $to ?>" class="form-control form-control-sm"></div>
            <div class="col-auto"><button class="btn btn-primary btn-sm">Aplicar</button></div>
            <div class="col-auto ms-auto">
                <a href="?from=<?= date('Y-m-01') ?>&to=<?= date('Y-m-d') ?>" class="btn btn-sm btn-outline-secondary">Este mes</a>
                <a href="?from=<?= date('Y-01-01') ?>&to=<?= date('Y-m-d') ?>" class="btn btn-sm btn-outline-secondary">Este año</a>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="row g-3 mb-4">
    <?php
    $kpis = [
        ['Total Tickets', $totalTickets,   'bi-ticket',           '#3B82F6'],
        ['Resueltos',     $resolvedTickets, 'bi-check-circle',     '#10B981'],
        ['Tasa Resolución',$resolutionRate.'%','bi-graph-up',     '#8B5CF6'],
        ['Tiempo Prom. (h)',$avgResolutionH,'bi-clock',           '#F59E0B'],
        ['SLA Vencidos',  $slaBreaches,    'bi-exclamation-triangle','#EF4444'],
        ['Satisfacción',  $satisfactionAvg . ($satisfactionAvg !== '-' ? '/5' : ''), 'bi-star', '#F59E0B'],
    ];
    foreach ($kpis as [$label, $value, $icon, $color]):
    ?>
    <div class="col-6 col-xl-2">
        <div class="card text-center p-3">
            <i class="bi <?= $icon ?> fs-3 mb-2" style="color:<?= $color ?>"></i>
            <div class="fw-bold fs-4" style="color:<?= $color ?>"><?= $value ?></div>
            <small class="text-muted"><?= $label ?></small>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- GRÁFICOS -->
<div class="row g-3 mb-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-graph-up me-2 text-primary"></i>Tendencia Diaria (30 días)</div>
            <div class="card-body"><canvas id="trendChart" style="max-height:220px;"></canvas></div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-pie-chart me-2 text-primary"></i>Por Estado</div>
            <div class="card-body d-flex align-items-center justify-content-center">
                <canvas id="statusPie" style="max-height:220px;"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-bar-chart me-2 text-primary"></i>Por Categoría</div>
            <div class="card-body"><canvas id="catBar" style="max-height:220px;"></canvas></div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-people me-2 text-primary"></i>Rendimiento por Agente</div>
            <div class="card-body">
                <?php if ($byAgent): ?>
                <table class="table table-sm mb-0">
                    <thead><tr><th>Agente</th><th>Asignados</th><th>Resueltos</th><th>%</th></tr></thead>
                    <tbody>
                        <?php foreach ($byAgent as $ag): ?>
                        <tr>
                            <td><?= sanitize($ag['name']) ?></td>
                            <td><?= $ag['total'] ?></td>
                            <td><?= $ag['resolved'] ?></td>
                            <td>
                                <?php $pct = $ag['total'] > 0 ? round($ag['resolved']/$ag['total']*100) : 0; ?>
                                <div class="progress" style="height:6px;width:80px;">
                                    <div class="progress-bar bg-success" style="width:<?= $pct ?>%"></div>
                                </div>
                                <small><?= $pct ?>%</small>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <?php else: ?>
                <p class="text-muted text-center py-3">Sin datos en el período.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
$trendLabels = array_column($dailyTrend, 'd');
$trendData   = array_column($dailyTrend, 'c');
$statusLabels = array_map(fn($r) => getStatusLabel($r['status'])[0], $byStatus);
$statusData   = array_column($byStatus, 'c');
$catLabels    = array_column($byCategory, 'name');
$catData      = array_column($byCategory, 'c');

$extraJs = '<script>
new Chart(document.getElementById("trendChart"), {
    type: "line",
    data: { labels: ' . json_encode($trendLabels) . ', datasets: [{
        label: "Tickets", data: ' . json_encode($trendData) . ',
        borderColor: "#3B82F6", backgroundColor: "rgba(59,130,246,.1)",
        borderWidth: 2, fill: true, tension: 0.4, pointRadius: 3
    }]},
    options: { plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true } } }
});
new Chart(document.getElementById("statusPie"), {
    type: "doughnut",
    data: { labels: ' . json_encode($statusLabels) . ', datasets: [{ data: ' . json_encode($statusData) . ',
        backgroundColor: ["#3B82F6","#F59E0B","#FBBF24","#10B981","#6B7280"] }] },
    options: { plugins: { legend: { position: "bottom", labels: { font: { size: 10 } } } }, cutout: "60%" }
});
new Chart(document.getElementById("catBar"), {
    type: "bar",
    data: { labels: ' . json_encode($catLabels) . ', datasets: [{
        label: "Tickets", data: ' . json_encode($catData) . ',
        backgroundColor: "#6366F1", borderRadius: 6
    }]},
    options: { indexAxis: "y", plugins: { legend: { display: false } }, scales: { x: { beginAtZero: true } } }
});
</script>';

require_once __DIR__ . '/../includes/footer.php';
?>
