<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

startSession();
requireRole(['admin']);

$page      = 'admin-users';
$pageTitle = 'Gestión de Usuarios';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'create') {
        $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
        db()->insert(
            "INSERT INTO users (name, email, password, role, department, phone) VALUES (?,?,?,?,?,?)",
            [sanitize($_POST['name']), trim($_POST['email']), $pass,
             $_POST['role'], sanitize($_POST['department'] ?? ''), sanitize($_POST['phone'] ?? '')]
        );
        flash('success', 'Usuario creado exitosamente.');
    }
    
    if ($action === 'edit') {
        $uid = (int)$_POST['user_id'];
        $fields = "name=?, email=?, role=?, department=?, phone=?, active=?, updated_at=NOW()";
        $params = [sanitize($_POST['name']), trim($_POST['email']), $_POST['role'],
                   sanitize($_POST['department'] ?? ''), sanitize($_POST['phone'] ?? ''),
                   isset($_POST['active']) ? 1 : 0];
        if (!empty($_POST['password'])) {
            $fields .= ', password=?';
            $params[] = password_hash($_POST['password'], PASSWORD_DEFAULT);
        }
        $params[] = $uid;
        db()->execute("UPDATE users SET $fields WHERE id=?", $params);
        auditLog('user_updated', 'users', $uid);
        flash('success', 'Usuario actualizado.');
    }

    if ($action === 'toggle') {
        $uid = (int)$_POST['user_id'];
        db()->execute("UPDATE users SET active=IF(active=1,0,1) WHERE id=?", [$uid]);
        flash('success', 'Estado del usuario actualizado.');
    }
    
    header('Location: ' . BASE_URL . '/admin/users.php');
    exit;
}

$users = db()->fetchAll(
    "SELECT u.*, (SELECT COUNT(*) FROM tickets WHERE requester_id=u.id) as ticket_count
     FROM users u ORDER BY u.role, u.name"
);

require_once __DIR__ . '/../includes/header.php';
?>

<?php if (flash('success')): ?>
<div class="alert alert-success"><i class="bi bi-check-circle me-2"></i><?= flash('success') ?></div>
<?php endif; ?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h6 class="mb-0"><?= count($users) ?> usuarios registrados</h6>
    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#userModal">
        <i class="bi bi-person-plus me-1"></i>Nuevo Usuario
    </button>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover mb-0">
            <thead class="table-light">
                <tr><th>Nombre</th><th>Correo</th><th>Rol</th><th>Departamento</th><th>Tickets</th><th>Último acceso</th><th>Estado</th><th>Acciones</th></tr>
            </thead>
            <tbody>
                <?php foreach ($users as $u):
                    $roleColors = ['admin'=>'danger','agent'=>'primary','client'=>'secondary'];
                ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center gap-2">
                            <div style="width:32px;height:32px;border-radius:50%;background:#3B82F6;color:#fff;display:flex;align-items:center;justify-content:center;font-size:.75rem;font-weight:700;">
                                <?= strtoupper(substr($u['name'],0,2)) ?>
                            </div>
                            <span class="fw-semibold"><?= sanitize($u['name']) ?></span>
                        </div>
                    </td>
                    <td><?= sanitize($u['email']) ?></td>
                    <td><span class="badge bg-<?= $roleColors[$u['role']] ?>"><?= ucfirst($u['role']) ?></span></td>
                    <td><small><?= sanitize($u['department'] ?? '-') ?></small></td>
                    <td><span class="badge bg-light text-dark border"><?= $u['ticket_count'] ?></span></td>
                    <td><small class="text-muted"><?= $u['last_login'] ? timeAgo($u['last_login']) : 'Nunca' ?></small></td>
                    <td><span class="badge bg-<?= $u['active']?'success':'secondary' ?>"><?= $u['active']?'Activo':'Inactivo' ?></span></td>
                    <td>
                        <button class="btn btn-sm btn-outline-primary" onclick="editUser(<?= json_encode($u) ?>)"><i class="bi bi-pencil"></i></button>
                        <form method="POST" style="display:inline;">
                            <input type="hidden" name="action" value="toggle">
                            <input type="hidden" name="user_id" value="<?= $u['id'] ?>">
                            <button type="submit" class="btn btn-sm btn-outline-<?= $u['active']?'warning':'success' ?>" title="<?= $u['active']?'Desactivar':'Activar' ?>">
                                <i class="bi bi-<?= $u['active']?'slash-circle':'check-circle' ?>"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- MODAL CREAR/EDITAR USUARIO -->
<div class="modal fade" id="userModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <input type="hidden" name="action" id="userAction" value="create">
                <input type="hidden" name="user_id" id="userId" value="">
                <div class="modal-header">
                    <h5 class="modal-title" id="userModalTitle">Nuevo Usuario</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label small fw-semibold">Nombre completo *</label>
                        <input type="text" name="name" id="u_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label small fw-semibold">Correo electrónico *</label>
                        <input type="email" name="email" id="u_email" class="form-control" required>
                    </div>
                    <div class="row g-3 mb-3">
                        <div class="col">
                            <label class="form-label small fw-semibold">Rol *</label>
                            <select name="role" id="u_role" class="form-select">
                                <option value="client">Cliente</option>
                                <option value="agent">Agente</option>
                                <option value="admin">Administrador</option>
                            </select>
                        </div>
                        <div class="col">
                            <label class="form-label small fw-semibold">Departamento</label>
                            <input type="text" name="department" id="u_dept" class="form-control">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label small fw-semibold">Teléfono</label>
                        <input type="text" name="phone" id="u_phone" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label small fw-semibold">Contraseña <span id="pwdHint" class="text-muted">(dejar vacío para no cambiar)</span></label>
                        <input type="password" name="password" id="u_pwd" class="form-control">
                    </div>
                    <div class="form-check" id="activeCheck" style="display:none;">
                        <input type="checkbox" name="active" id="u_active" class="form-check-input" value="1" checked>
                        <label class="form-check-label small" for="u_active">Usuario activo</label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$extraJs = '<script>
function editUser(u) {
    document.getElementById("userAction").value = "edit";
    document.getElementById("userId").value = u.id;
    document.getElementById("userModalTitle").textContent = "Editar Usuario";
    document.getElementById("u_name").value = u.name;
    document.getElementById("u_email").value = u.email;
    document.getElementById("u_role").value = u.role;
    document.getElementById("u_dept").value = u.department || "";
    document.getElementById("u_phone").value = u.phone || "";
    document.getElementById("pwdHint").style.display = "inline";
    document.getElementById("activeCheck").style.display = "block";
    document.getElementById("u_active").checked = u.active == 1;
    new bootstrap.Modal(document.getElementById("userModal")).show();
}
document.getElementById("userModal").addEventListener("hidden.bs.modal", function() {
    document.getElementById("userAction").value = "create";
    document.getElementById("userModalTitle").textContent = "Nuevo Usuario";
    document.getElementById("activeCheck").style.display = "none";
    document.querySelector("#userModal form").reset();
});
</script>';
require_once __DIR__ . '/../includes/footer.php';
?>
