<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

startSession();
if (!isAgent()) { echo '<p class="text-muted">Sin acceso</p>'; exit; }

$id      = (int)($_GET['id'] ?? 0);
$history = db()->fetchAll(
    "SELECT ah.*, u.name as user_name FROM asset_history ah
     JOIN users u ON ah.user_id=u.id WHERE ah.asset_id=? ORDER BY ah.created_at DESC", [$id]
);

if (empty($history)): ?>
<p class="text-muted text-center py-3"><i class="bi bi-inbox"></i> Sin historial registrado</p>
<?php else: ?>
<div class="table-responsive">
<table class="table table-sm">
    <thead><tr><th>Fecha</th><th>Acción</th><th>Responsable</th><th>Notas</th></tr></thead>
    <tbody>
    <?php foreach ($history as $h): ?>
    <tr>
        <td><small><?= formatDate($h['created_at']) ?></small></td>
        <td><span class="badge bg-light text-dark border"><?= sanitize($h['action']) ?></span></td>
        <td><?= sanitize($h['user_name']) ?></td>
        <td><small><?= sanitize($h['notes'] ?? '') ?></small></td>
    </tr>
    <?php endforeach; ?>
    </tbody>
</table>
</div>
<?php endif;
