<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireRole(['admin']);

$msg = '';
$users = db()->fetchAll("SELECT id, name, email, role FROM users ORDER BY name");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uid  = (int)$_POST['user_id'];
    $pass = $_POST['new_password'];
    if (strlen($pass) >= 6) {
        $hash = password_hash($pass, PASSWORD_DEFAULT);
        db()->execute("UPDATE users SET password=? WHERE id=?", [$hash, $uid]);
        $msg = '✅ Contraseña actualizada exitosamente.';
    } else {
        $msg = '❌ La contraseña debe tener mínimo 6 caracteres.';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Cambiar Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5" style="max-width:500px;">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">🔑 Cambiar Contraseña de Usuario</h5>
        </div>
        <div class="card-body">
            <?php if ($msg): ?>
            <div class="alert alert-<?= str_contains($msg,'✅')?'success':'danger' ?>">
                <?= $msg ?>
            </div>
            <?php endif; ?>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label fw-semibold">Seleccionar Usuario</label>
                    <select name="user_id" class="form-select" required>
                        <option value="">-- Seleccione un usuario --</option>
                        <?php foreach ($users as $u): ?>
                        <option value="<?= $u['id'] ?>">
                            <?= $u['name'] ?> (<?= $u['email'] ?>) - <?= $u['role'] ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-semibold">Nueva Contraseña</label>
                    <input type="password" name="new_password" class="form-control"
                           placeholder="Mínimo 6 caracteres" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">
                    Cambiar Contraseña
                </button>
            </form>
            <hr>
            <a href="<?= BASE_URL ?>/admin/users.php" class="btn btn-outline-secondary w-100">
                ← Volver a Usuarios
            </a>
        </div>
    </div>
</div>
</body>
</html>
```

5. Haz clic en **"Guardar cambios"**

---

Luego entra a:
```
https://evolucionamos.com/helpdesk/cambiar-clave.php