<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$page      = 'dashboard';
$pageTitle = 'Dashboard';
$uid       = $_SESSION['user_id'];
$role      = $_SESSION['user_role'];

// ── Estadísticas según rol ──────────────────────────────────
$filter = ($role === 'client') ? "AND t.requester_id = $uid" : '';

$stats = [
    'open'        => db()->fetchOne("SELECT COUNT(*) c FROM tickets t WHERE status='open' $filter")['c'],
    'in_progress' => db()->fetchOne("SELECT COUNT(*) c FROM tickets t WHERE status='in_progress' $filter")['c'],
    'resolved'    => db()->fetchOne("SELECT COUNT(*) c FROM tickets t WHERE status='resolved' $filter")['c'],
    'closed'      => db()->fetchOne("SELECT COUNT(*) c FROM tickets t WHERE status='closed' $filter")['c'],
];

// Tickets recientes
$recentTickets = db()->fetchAll(
    "SELECT t.*, u.name as requester_name, a.name as agent_name, c.name as cat_name
     FROM tickets t
     JOIN users u ON t.requester_id = u.id
     LEFT JOIN users a ON t.agent_id = a.id
     LEFT JOIN categories c ON t.category_id = c.id
     WHERE 1=1 $filter
     ORDER BY t.created_at DESC LIMIT 8"
);

// Para gráficos (admin/agent)
$byStatus = db()->fetchAll("SELECT status, COUNT(*) c FROM tickets GROUP BY status");
$byPriority = db()->fetchAll("SELECT priority, COUNT(*) c FROM tickets GROUP BY priority");
$byCategory = db()->fetchAll(
    "SELECT c.name, COUNT(t.id) c FROM tickets t
     LEFT JOIN categories c ON t.category_id = c.id
     WHERE c.parent_id IS NULL
     GROUP BY c.id ORDER BY c DESC LIMIT 5"
);

// SLA vencidos
$slaBreach = db()->fetchOne(
    "SELECT COUNT(*) c FROM tickets WHERE due_date < NOW() AND status NOT IN ('resolved','closed') $filter"
)['c'];

// Activos
$assetsCount = db()->fetchOne("SELECT COUNT(*) c FROM assets WHERE status='active'")['c'];

require_once __DIR__ . '/includes/header.php';
?>

<?php if (flash('success')): ?>
<div class="alert alert-success d-flex align-items-center gap-2">
    <i class="bi bi-check-circle-fill"></i> <?= flash('success') ?>
</div>
<?php endif; ?>

<!-- STAT CARDS -->
<div class="row g-3 mb-4">
    <div class="col-6 col-xl-3">
        <div class="stat-card d-flex justify-content-between align-items-center" style="background:linear-gradient(135deg,#3B82F6,#1D4ED8);">
            <div>
                <div class="stat-value"><?= $stats['open'] ?></div>
                <div class="stat-label">Tickets Abiertos</div>
            </div>
            <i class="bi bi-ticket-perforated stat-icon"></i>
        </div>
    </div>
    <div class="col-6 col-xl-3">
        <div class="stat-card d-flex justify-content-between align-items-center" style="background:linear-gradient(135deg,#F59E0B,#D97706);">
            <div>
                <div class="stat-value"><?= $stats['in_progress'] ?></div>
                <div class="stat-label">En Progreso</div>
            </div>
            <i class="bi bi-gear stat-icon"></i>
        </div>
    </div>
    <div class="col-6 col-xl-3">
        <div class="stat-card d-flex justify-content-between align-items-center" style="background:linear-gradient(135deg,#10B981,#059669);">
            <div>
                <div class="stat-value"><?= $stats['resolved'] ?></div>
                <div class="stat-label">Resueltos</div>
            </div>
            <i class="bi bi-check-circle stat-icon"></i>
        </div>
    </div>
    <div class="col-6 col-xl-3">
        <div class="stat-card d-flex justify-content-between align-items-center" style="background:linear-gradient(135deg,#EF4444,#B91C1C);">
            <div>
                <div class="stat-value"><?= $slaBreach ?></div>
                <div class="stat-label">SLA Vencidos</div>
            </div>
            <i class="bi bi-exclamation-triangle stat-icon"></i>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <?php if (isAgent()): ?>
    <!-- GRÁFICOS SOLO PARA AGENTES/ADMIN -->
    <div class="col-md-5">
        <div class="card h-100">
            <div class="card-header py-3">
                <i class="bi bi-pie-chart me-2 text-primary"></i>Tickets por Estado
            </div>
            <div class="card-body d-flex align-items-center justify-content-center">
                <canvas id="statusChart" style="max-height:200px;"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card h-100">
            <div class="card-header py-3">
                <i class="bi bi-bar-chart me-2 text-primary"></i>Tickets por Categoría
            </div>
            <div class="card-body">
                <canvas id="catChart" style="max-height:200px;"></canvas>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<!-- TICKETS RECIENTES -->
<div class="card">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <span><i class="bi bi-clock-history me-2 text-primary"></i>Tickets Recientes</span>
        <a href="<?= BASE_URL ?>/tickets.php" class="btn btn-sm btn-outline-primary">Ver todos</a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>N° Ticket</th>
                        <th>Título</th>
                        <th>Categoría</th>
                        <th>Estado</th>
                        <th>Prioridad</th>
                        <?php if (isAgent()): ?><th>Solicitante</th><?php endif; ?>
                        <th>Creado</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentTickets as $t):
                        [$statusLabel, $statusClass] = getStatusLabel($t['status']);
                        [$prioLabel, $prioClass]     = getPriorityLabel($t['priority']);
                    ?>
                    <tr onclick="location.href='<?= BASE_URL ?>/ticket-view.php?id=<?= $t['id'] ?>'">
                        <td><code class="text-primary"><?= $t['ticket_number'] ?></code></td>
                        <td class="fw-semibold" style="max-width:220px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;">
                            <?= sanitize($t['title']) ?>
                        </td>
                        <td><small><?= sanitize($t['cat_name'] ?? '-') ?></small></td>
                        <td><span class="ticket-badge <?= $statusClass ?>"><?= $statusLabel ?></span></td>
                        <td><span class="<?= $prioClass ?> fw-semibold small"><?= $prioLabel ?></span></td>
                        <?php if (isAgent()): ?><td><small><?= sanitize($t['requester_name']) ?></small></td><?php endif; ?>
                        <td><small class="text-muted"><?= timeAgo($t['created_at']) ?></small></td>
                        <td>
                            <a href="<?= BASE_URL ?>/ticket-view.php?id=<?= $t['id'] ?>" class="btn btn-sm btn-outline-secondary" onclick="event.stopPropagation()">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($recentTickets)): ?>
                    <tr><td colspan="8" class="text-center text-muted py-4">No hay tickets aún. <a href="<?= BASE_URL ?>/ticket-create.php">Crea el primero</a></td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
$extraJs = '';
if (isAgent()):
    $statusData   = array_column($byStatus, 'c');
    $statusLabels = array_map(fn($r) => getStatusLabel($r['status'])[0], $byStatus);
    $catLabels    = array_column($byCategory, 'name');
    $catData      = array_column($byCategory, 'c');
    $extraJs = '<script>
    new Chart(document.getElementById("statusChart"), {
        type: "doughnut",
        data: { labels: ' . json_encode($statusLabels) . ', datasets: [{ data: ' . json_encode($statusData) . ',
            backgroundColor: ["#3B82F6","#F59E0B","#FBBF24","#10B981","#6B7280"] }] },
        options: { plugins: { legend: { position: "bottom", labels: { font: { size: 11 } } } }, cutout: "65%" }
    });
    new Chart(document.getElementById("catChart"), {
        type: "bar",
        data: { labels: ' . json_encode($catLabels) . ', datasets: [{ label: "Tickets", data: ' . json_encode($catData) . ',
            backgroundColor: "#3B82F6", borderRadius: 6 }] },
        options: { plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true } } }
    });
    </script>';
endif;

require_once __DIR__ . '/includes/footer.php';
?>
