<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$id = (int)($_GET['id'] ?? 0);
if (!$id) die('Archivo no especificado.');

$att = db()->fetchOne("SELECT * FROM ticket_attachments WHERE id=?", [$id]);
if (!$att) die('Archivo no encontrado.');

// Verificar acceso al ticket
$ticket = db()->fetchOne("SELECT requester_id FROM tickets WHERE id=?", [$att['ticket_id']]);
if (!$ticket) die('Ticket no encontrado.');
if ($_SESSION['user_role'] === 'client' && $ticket['requester_id'] != $_SESSION['user_id']) die('Sin acceso.');

$filepath = UPLOAD_PATH . $att['filename'];
if (!file_exists($filepath)) die('Archivo no disponible en servidor.');

$ext  = strtolower(pathinfo($att['original_name'], PATHINFO_EXTENSION));
$mime = mime_content_type($filepath) ?: 'application/octet-stream';

header('Content-Type: ' . $mime);
header('Content-Disposition: attachment; filename="' . $att['original_name'] . '"');
header('Content-Length: ' . filesize($filepath));
header('Cache-Control: private');
readfile($filepath);
exit;
