<?php
// includes/header.php - Layout compartido
$currentUser = currentUser();
$unread      = getUnreadCount($currentUser['id']);
$page        = $page ?? 'dashboard';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #1E3A5F;
            --primary-light: #2E5090;
            --accent: #3B82F6;
            --success: #10B981;
            --warning: #F59E0B;
            --danger: #EF4444;
            --sidebar-w: 260px;
            --bg: #F0F4F8;
        }
        body { background: var(--bg); font-family: 'Segoe UI', sans-serif; overflow-x: hidden; }
        
        /* SIDEBAR */
        .sidebar {
            width: var(--sidebar-w); min-height: 100vh; background: var(--primary);
            position: fixed; top: 0; left: 0; z-index: 1000;
            display: flex; flex-direction: column; transition: transform .3s;
        }
        .sidebar-brand { padding: 1.5rem 1.25rem; border-bottom: 1px solid rgba(255,255,255,.1); }
        .sidebar-brand h5 { color: #fff; margin: 0; font-weight: 700; font-size: 1rem; }
        .sidebar-brand small { color: rgba(255,255,255,.5); font-size: .75rem; }
        .sidebar-nav { flex: 1; padding: .75rem 0; overflow-y: auto; }
        .sidebar-nav .nav-section {
            text-transform: uppercase; font-size: .65rem; letter-spacing: 1px;
            color: rgba(255,255,255,.4); padding: .75rem 1.25rem .25rem;
        }
        .sidebar-nav .nav-link {
            color: rgba(255,255,255,.75); padding: .6rem 1.25rem;
            border-radius: 0; display: flex; align-items: center; gap: .75rem;
            font-size: .875rem; transition: all .2s;
        }
        .sidebar-nav .nav-link:hover,
        .sidebar-nav .nav-link.active {
            color: #fff; background: rgba(255,255,255,.12);
        }
        .sidebar-nav .nav-link .bi { font-size: 1rem; width: 1.2rem; text-align: center; }
        .sidebar-footer { padding: 1rem 1.25rem; border-top: 1px solid rgba(255,255,255,.1); }
        .sidebar-footer .avatar {
            width: 36px; height: 36px; border-radius: 50%;
            background: var(--accent); color: #fff;
            display: inline-flex; align-items: center; justify-content: center;
            font-weight: 700; font-size: .85rem;
        }

        /* MAIN CONTENT */
        .main-content { margin-left: var(--sidebar-w); min-height: 100vh; }
        .topbar {
            background: #fff; padding: .75rem 1.5rem; border-bottom: 1px solid #e5e7eb;
            display: flex; align-items: center; justify-content: space-between;
            position: sticky; top: 0; z-index: 100;
        }
        .topbar-title { font-weight: 600; color: var(--primary); margin: 0; font-size: 1.1rem; }
        .page-body { padding: 1.5rem; }

        /* CARDS */
        .card { border: none; border-radius: 12px; box-shadow: 0 1px 3px rgba(0,0,0,.08); }
        .card-header { background: transparent; border-bottom: 1px solid #f0f0f0; font-weight: 600; }
        .stat-card { border-radius: 12px; padding: 1.25rem; color: #fff; }
        .stat-card .stat-value { font-size: 2rem; font-weight: 700; }
        .stat-card .stat-label { opacity: .85; font-size: .85rem; }
        .stat-card .stat-icon { font-size: 2.5rem; opacity: .3; }

        /* BADGES / STATUS */
        .badge-open        { background: #EFF6FF; color: #1D4ED8; }
        .badge-progress    { background: #FFF7ED; color: #C2410C; }
        .badge-pending     { background: #FEFCE8; color: #A16207; }
        .badge-resolved    { background: #F0FDF4; color: #166534; }
        .badge-closed      { background: #F4F4F5; color: #71717A; }
        .ticket-badge { padding: .3rem .75rem; border-radius: 50px; font-size: .75rem; font-weight: 600; }

        .priority-low      { color: #6B7280; }
        .priority-medium   { color: #D97706; }
        .priority-high     { color: #DC2626; }
        .priority-critical { color: #7C3AED; font-weight: 700; }

        /* TABLES */
        .table-hover tbody tr:hover { background: #F8FAFF; cursor: pointer; }
        .table th { font-size: .78rem; text-transform: uppercase; letter-spacing: .5px; color: #6B7280; font-weight: 600; border: none; }
        .table td { vertical-align: middle; border-color: #F3F4F6; }

        /* ALERTS */
        .alert { border: none; border-radius: 10px; }

        /* BUTTONS */
        .btn-primary { background: var(--accent); border-color: var(--accent); }
        .btn-primary:hover { background: #2563EB; border-color: #2563EB; }

        /* TICKET DETAIL */
        .comment-bubble { background: #F8FAFF; border-radius: 10px; padding: 1rem; margin-bottom: 1rem; }
        .comment-bubble.internal { background: #FFFBEB; border-left: 3px solid #F59E0B; }
        .comment-bubble.agent    { background: #EFF6FF; border-left: 3px solid #3B82F6; }

        /* MOBILE */
        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.open { transform: translateX(0); }
            .main-content { margin-left: 0; }
        }

        /* KNOWLEDGE */
        .kb-card { border-radius: 10px; transition: transform .2s, box-shadow .2s; }
        .kb-card:hover { transform: translateY(-3px); box-shadow: 0 4px 15px rgba(0,0,0,.12); }
    </style>
</head>
<body>

<!-- SIDEBAR -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-brand">
        <div class="d-flex align-items-center gap-2">
            <div style="width:36px;height:36px;background:var(--accent);border-radius:8px;display:flex;align-items:center;justify-content:center;">
                <i class="bi bi-headset text-white fs-5"></i>
            </div>
            <div>
                <h5 class="mb-0"><?= SITE_NAME ?></h5>
                <small><?= SITE_COMPANY ?></small>
            </div>
        </div>
    </div>

    <nav class="sidebar-nav">
        <div class="nav-section">Principal</div>
        <a href="<?= BASE_URL ?>/dashboard.php" class="nav-link <?= $page==='dashboard'?'active':'' ?>">
            <i class="bi bi-grid-1x2"></i> Dashboard
        </a>

        <div class="nav-section">Tickets</div>
        <a href="<?= BASE_URL ?>/tickets.php" class="nav-link <?= $page==='tickets'?'active':'' ?>">
            <i class="bi bi-ticket-perforated"></i> Mis Tickets
        </a>
        <a href="<?= BASE_URL ?>/ticket-create.php" class="nav-link <?= $page==='ticket-create'?'active':'' ?>">
            <i class="bi bi-plus-circle"></i> Nuevo Ticket
        </a>

        <?php if (isAgent()): ?>
        <div class="nav-section">Gestión</div>
        <a href="<?= BASE_URL ?>/tickets.php?view=all" class="nav-link">
            <i class="bi bi-inbox"></i> Todos los Tickets
        </a>
        <a href="<?= BASE_URL ?>/assets.php" class="nav-link <?= $page==='assets'?'active':'' ?>">
            <i class="bi bi-laptop"></i> Inventario
        </a>
        <?php endif; ?>

        <div class="nav-section">Conocimiento</div>
        <a href="<?= BASE_URL ?>/knowledge.php" class="nav-link <?= $page==='knowledge'?'active':'' ?>">
            <i class="bi bi-book"></i> Base de Conocimiento
        </a>

        <?php if (isAdmin()): ?>
        <div class="nav-section">Administración</div>
        <a href="<?= BASE_URL ?>/admin/users.php" class="nav-link <?= $page==='admin-users'?'active':'' ?>">
            <i class="bi bi-people"></i> Usuarios
        </a>
        <a href="<?= BASE_URL ?>/admin/categories.php" class="nav-link <?= $page==='admin-cats'?'active':'' ?>">
            <i class="bi bi-diagram-3"></i> Categorías
        </a>
        <a href="<?= BASE_URL ?>/admin/reports.php" class="nav-link <?= $page==='admin-reports'?'active':'' ?>">
            <i class="bi bi-bar-chart"></i> Reportes
        </a>
        <a href="<?= BASE_URL ?>/admin/audit.php" class="nav-link <?= $page==='admin-audit'?'active':'' ?>">
            <i class="bi bi-shield-check"></i> Auditoría
        </a>
        <?php endif; ?>
    </nav>

    <div class="sidebar-footer">
        <div class="d-flex align-items-center gap-2">
            <span class="avatar"><?= strtoupper(substr($currentUser['name'], 0, 2)) ?></span>
            <div style="flex:1;overflow:hidden;">
                <div style="color:#fff;font-size:.8rem;font-weight:600;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;">
                    <?= sanitize($currentUser['name']) ?>
                </div>
                <div style="color:rgba(255,255,255,.5);font-size:.7rem;"><?= ucfirst($currentUser['role']) ?></div>
            </div>
            <a href="<?= BASE_URL ?>/logout.php" class="text-white-50" title="Cerrar sesión">
                <i class="bi bi-box-arrow-right"></i>
            </a>
        </div>
    </div>
</aside>

<!-- MAIN CONTENT -->
<div class="main-content">
    <!-- TOPBAR -->
    <div class="topbar">
        <div class="d-flex align-items-center gap-3">
            <button class="btn btn-sm btn-outline-secondary d-md-none" onclick="document.getElementById('sidebar').classList.toggle('open')">
                <i class="bi bi-list"></i>
            </button>
            <h6 class="topbar-title"><?= $pageTitle ?? SITE_NAME ?></h6>
        </div>
        <div class="d-flex align-items-center gap-3">
            <a href="<?= BASE_URL ?>/ticket-create.php" class="btn btn-primary btn-sm">
                <i class="bi bi-plus"></i> Nuevo Ticket
            </a>
            <div class="dropdown">
                <button class="btn btn-sm btn-outline-secondary position-relative" data-bs-toggle="dropdown">
                    <i class="bi bi-bell"></i>
                    <?php if ($unread > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size:.6rem;">
                        <?= $unread ?>
                    </span>
                    <?php endif; ?>
                </button>
                <div class="dropdown-menu dropdown-menu-end shadow" style="min-width:300px;">
                    <?php
                    $notifs = db()->fetchAll(
                        "SELECT * FROM notifications WHERE user_id=? ORDER BY created_at DESC LIMIT 8",
                        [$currentUser['id']]
                    );
                    if ($notifs):
                        foreach ($notifs as $n):
                    ?>
                    <div class="dropdown-item <?= $n['read_at']?'':'fw-semibold' ?>" style="white-space:normal;cursor:default;">
                        <div style="font-size:.8rem;"><?= sanitize($n['title']) ?></div>
                        <small class="text-muted"><?= timeAgo($n['created_at']) ?></small>
                    </div>
                    <?php endforeach; else: ?>
                    <div class="dropdown-item text-muted text-center">Sin notificaciones</div>
                    <?php endif; ?>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item text-center text-primary small" href="<?= BASE_URL ?>/notifications.php">Ver todas</a>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
