<?php
// Clase de correo simple con PHPMailer (si está disponible) o mail() nativo
// Para usar PHPMailer: composer require phpmailer/phpmailer
// O subir la carpeta PHPMailer al servidor

class Mailer {
    public function send($to, $toName, $subject, $htmlBody) {
        if (!MAIL_ENABLED) return false;

        // Intentar con PHPMailer si está disponible
        $phpmailerPath = __DIR__ . '/../vendor/phpmailer/phpmailer/src/PHPMailer.php';
        if (file_exists($phpmailerPath)) {
            return $this->sendWithPHPMailer($to, $toName, $subject, $htmlBody);
        }
        
        // Fallback: mail() nativo
        return $this->sendNative($to, $subject, $htmlBody);
    }

    private function sendWithPHPMailer($to, $toName, $subject, $htmlBody) {
        require_once __DIR__ . '/../vendor/phpmailer/phpmailer/src/PHPMailer.php';
        require_once __DIR__ . '/../vendor/phpmailer/phpmailer/src/SMTP.php';
        require_once __DIR__ . '/../vendor/phpmailer/phpmailer/src/Exception.php';

        try {
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $mail->isSMTP();
            $mail->Host       = MAIL_HOST;
            $mail->SMTPAuth   = true;
            $mail->Username   = MAIL_USER;
            $mail->Password   = MAIL_PASS;
            $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port       = MAIL_PORT;
            $mail->CharSet    = 'UTF-8';
            $mail->setFrom(MAIL_USER, MAIL_FROM_NAME);
            $mail->addAddress($to, $toName);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body    = $htmlBody;
            $mail->send();
            return true;
        } catch (Exception $e) {
            error_log("Mailer Error: " . $e->getMessage());
            return false;
        }
    }

    private function sendNative($to, $subject, $htmlBody) {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: " . MAIL_FROM_NAME . " <" . MAIL_USER . ">\r\n";
        return mail($to, $subject, $htmlBody, $headers);
    }
}
