<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();

// Si ya está logueado, redirigir
if (isLoggedIn()) {
    header('Location: ' . BASE_URL . '/dashboard.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        $error = 'Por favor complete todos los campos.';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Ingrese un correo electrónico válido.';
    } elseif (login($email, $password)) {
    header('Location: /helpdesk/dashboard.php');
    exit;
    } else {
        $error = 'Correo o contraseña incorrectos. Verifique sus credenciales.';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - Iniciar Sesión</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root { --primary: #1E3A5F; --accent: #3B82F6; }
        body {
            min-height: 100vh; background: linear-gradient(135deg, var(--primary) 0%, #2E5090 50%, var(--accent) 100%);
            display: flex; align-items: center; justify-content: center; font-family: 'Segoe UI', sans-serif;
        }
        .login-card {
            width: 420px; max-width: 95%; background: #fff;
            border-radius: 16px; padding: 2.5rem;
            box-shadow: 0 20px 60px rgba(0,0,0,.25);
        }
        .login-logo {
            width: 64px; height: 64px; background: var(--accent);
            border-radius: 16px; display: flex; align-items: center; justify-content: center;
            margin: 0 auto 1.5rem;
        }
        .btn-login { background: var(--accent); border: none; color: #fff; padding: .75rem; font-weight: 600; border-radius: 10px; }
        .btn-login:hover { background: #2563EB; color: #fff; }
        .form-control { border-radius: 10px; padding: .65rem 1rem; border-color: #E5E7EB; }
        .form-control:focus { border-color: var(--accent); box-shadow: 0 0 0 3px rgba(59,130,246,.15); }
        .demo-box { background: #F0F9FF; border-radius: 10px; padding: 1rem; border: 1px solid #BAE6FD; margin-top: 1.5rem; }
        .demo-box p { margin: 0; font-size: .8rem; color: #0369A1; }
    </style>
</head>
<body>
<div class="login-card">
    <div class="login-logo">
        <i class="bi bi-headset fs-2 text-white"></i>
    </div>
    <h4 class="text-center fw-bold mb-1" style="color:#1E3A5F;"><?= SITE_NAME ?></h4>
    <p class="text-center text-muted mb-4 small"><?= SITE_COMPANY ?></p>

    <?php if ($error): ?>
    <div class="alert alert-danger d-flex align-items-center gap-2 py-2" style="border-radius:10px;font-size:.875rem;">
        <i class="bi bi-exclamation-circle"></i> <?= $error ?>
    </div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label fw-semibold small">Correo electrónico</label>
            <div class="input-group">
                <span class="input-group-text" style="border-radius:10px 0 0 10px;border-color:#E5E7EB;">
                    <i class="bi bi-envelope text-muted"></i>
                </span>
                <input type="email" name="email" class="form-control" style="border-radius:0 10px 10px 0;"
                       value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
                       placeholder="usuario@empresa.com" required autofocus>
            </div>
        </div>
        <div class="mb-4">
            <label class="form-label fw-semibold small">Contraseña</label>
            <div class="input-group">
                <span class="input-group-text" style="border-radius:10px 0 0 10px;border-color:#E5E7EB;">
                    <i class="bi bi-lock text-muted"></i>
                </span>
                <input type="password" name="password" id="pwd" class="form-control" style="border-radius:0 10px 10px 0;"
                       placeholder="••••••••" required>
                <button type="button" class="btn btn-outline-secondary" style="border-radius:0 10px 10px 0;border-color:#E5E7EB;"
                        onclick="var p=document.getElementById('pwd');p.type=p.type==='password'?'text':'password'">
                    <i class="bi bi-eye"></i>
                </button>
            </div>
        </div>
        <button type="submit" class="btn btn-login w-100">
            <i class="bi bi-box-arrow-in-right me-2"></i>Iniciar Sesión
        </button>
    </form>

    <div class="demo-box">
        <p><strong><i class="bi bi-info-circle me-1"></i>Cuentas demo (contraseña: password)</strong></p>
        <p>Admin: admin@helpdesk.com</p>
        <p>Agente: agente@helpdesk.com</p>
        <p>Usuario: usuario@helpdesk.com</p>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
