<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$page      = 'knowledge';
$pageTitle = 'Base de Conocimiento';

// Ver artículo individual
if (isset($_GET['id'])) {
    $articleId = (int)$_GET['id'];
    $article   = db()->fetchOne(
        "SELECT kb.*, u.name as author_name, c.name as cat_name
         FROM knowledge_base kb
         JOIN users u ON kb.author_id = u.id
         LEFT JOIN categories c ON kb.category_id = c.id
         WHERE kb.id=? AND kb.published=1", [$articleId]
    );
    if ($article) {
        db()->execute("UPDATE knowledge_base SET views=views+1 WHERE id=?", [$articleId]);
        
        // Votar útil
        if (isset($_POST['helpful'])) {
            if ($_POST['helpful'] === 'yes') db()->execute("UPDATE knowledge_base SET helpful_yes=helpful_yes+1 WHERE id=?", [$articleId]);
            else db()->execute("UPDATE knowledge_base SET helpful_no=helpful_no+1 WHERE id=?", [$articleId]);
            header('Location: ' . BASE_URL . '/knowledge.php?id=' . $articleId . '&voted=1');
            exit;
        }

        require_once __DIR__ . '/includes/header.php';
        ?>
        <div class="row justify-content-center">
        <div class="col-lg-9">
            <div class="mb-3">
                <a href="<?= BASE_URL ?>/knowledge.php" class="btn btn-sm btn-outline-secondary">
                    <i class="bi bi-arrow-left me-1"></i>Volver al índice
                </a>
            </div>
            <div class="card">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <span class="badge bg-primary mb-2"><?= sanitize($article['cat_name'] ?? 'General') ?></span>
                            <h3 class="fw-bold"><?= sanitize($article['title']) ?></h3>
                            <small class="text-muted">
                                Por <strong><?= sanitize($article['author_name']) ?></strong>
                                · <?= formatDate($article['updated_at']) ?>
                                · <?= $article['views'] ?> vistas
                            </small>
                        </div>
                        <?php if (isAgent()): ?>
                        <a href="<?= BASE_URL ?>/admin/knowledge-edit.php?id=<?= $article['id'] ?>" class="btn btn-sm btn-outline-primary">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                    <hr>
                    <div class="kb-content" style="line-height:1.8;">
                        <?= $article['content'] /* HTML permitido de la base de datos */ ?>
                    </div>
                    <?php if ($article['tags']): ?>
                    <div class="mt-3">
                        <?php foreach (explode(',', $article['tags']) as $tag): ?>
                        <span class="badge bg-light text-dark border"><?= sanitize(trim($tag)) ?></span>
                        <?php endforeach; ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="card-footer">
                    <?php if (!isset($_GET['voted'])): ?>
                    <form method="POST" class="d-flex align-items-center gap-3">
                        <span class="small text-muted">¿Este artículo fue útil?</span>
                        <button type="submit" name="helpful" value="yes" class="btn btn-sm btn-outline-success">
                            <i class="bi bi-hand-thumbs-up me-1"></i>Sí (<?= $article['helpful_yes'] ?>)
                        </button>
                        <button type="submit" name="helpful" value="no" class="btn btn-sm btn-outline-danger">
                            <i class="bi bi-hand-thumbs-down me-1"></i>No (<?= $article['helpful_no'] ?>)
                        </button>
                    </form>
                    <?php else: ?>
                    <p class="text-muted small mb-0"><i class="bi bi-check-circle text-success me-2"></i>¡Gracias por tu opinión!</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        </div>
        <?php
        require_once __DIR__ . '/includes/footer.php';
        exit;
    }
}

// Crear artículo (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isAgent()) {
    $title   = trim($_POST['title'] ?? '');
    $content = $_POST['content'] ?? '';
    $catId   = $_POST['category_id'] ?: null;
    $tags    = trim($_POST['tags'] ?? '');
    if (strlen($title) > 3 && strlen($content) > 10) {
        $id = db()->insert(
            "INSERT INTO knowledge_base (title, content, category_id, author_id, tags, published) VALUES (?,?,?,?,?,1)",
            [$title, $content, $catId, $_SESSION['user_id'], $tags]
        );
        auditLog('kb_created', 'knowledge_base', $id);
        flash('success', 'Artículo publicado exitosamente.');
        redirect('knowledge.php?id=' . $id);
    }
}

// Índice
$search  = trim($_GET['q'] ?? '');
$catFilt = $_GET['cat'] ?? '';
$where   = ['kb.published=1'];
$params  = [];
if ($search)  { $where[] = '(kb.title LIKE ? OR kb.content LIKE ? OR kb.tags LIKE ?)'; $params = array_merge($params, ["%$search%","%$search%","%$search%"]); }
if ($catFilt) { $where[] = 'kb.category_id=?'; $params[] = $catFilt; }
$whereStr = implode(' AND ', $where);

$articles = db()->fetchAll(
    "SELECT kb.*, u.name as author_name, c.name as cat_name
     FROM knowledge_base kb JOIN users u ON kb.author_id=u.id
     LEFT JOIN categories c ON kb.category_id=c.id
     WHERE $whereStr ORDER BY kb.views DESC, kb.updated_at DESC", $params
);
$cats = db()->fetchAll("SELECT id, name FROM categories WHERE parent_id IS NULL AND active=1");

require_once __DIR__ . '/includes/header.php';
?>

<?php if (flash('success')): ?>
<div class="alert alert-success"><i class="bi bi-check-circle me-2"></i><?= flash('success') ?></div>
<?php endif; ?>

<div class="row g-3">
    <!-- ARTÍCULOS -->
    <div class="col-lg-8">
        <!-- SEARCH + FILTERS -->
        <div class="card mb-3">
            <div class="card-body py-2">
                <form method="GET" class="row g-2">
                    <div class="col"><input type="text" name="q" class="form-control" placeholder="🔍 Buscar artículos..." value="<?= htmlspecialchars($search) ?>"></div>
                    <div class="col-auto">
                        <select name="cat" class="form-select">
                            <option value="">Todas las categorías</option>
                            <?php foreach ($cats as $c): ?>
                            <option value="<?= $c['id'] ?>" <?= $catFilt==$c['id']?'selected':'' ?>><?= sanitize($c['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-auto"><button class="btn btn-primary">Buscar</button></div>
                </form>
            </div>
        </div>

        <!-- LISTADO -->
        <div class="row g-3">
            <?php foreach ($articles as $art): ?>
            <div class="col-12">
                <a href="<?= BASE_URL ?>/knowledge.php?id=<?= $art['id'] ?>" class="text-decoration-none">
                    <div class="card kb-card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-1">
                                <span class="badge bg-primary" style="font-size:.7rem;"><?= sanitize($art['cat_name'] ?? 'General') ?></span>
                                <small class="text-muted"><i class="bi bi-eye me-1"></i><?= $art['views'] ?></small>
                            </div>
                            <h6 class="mb-1 text-dark fw-semibold"><?= sanitize($art['title']) ?></h6>
                            <p class="text-muted small mb-1" style="display:-webkit-box;-webkit-line-clamp:2;-webkit-box-orient:vertical;overflow:hidden;">
                                <?= strip_tags($art['content']) ?>
                            </p>
                            <div class="d-flex gap-3">
                                <small class="text-muted">Por <?= sanitize($art['author_name']) ?></small>
                                <small class="text-success"><i class="bi bi-hand-thumbs-up me-1"></i><?= $art['helpful_yes'] ?></small>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; ?>
            <?php if (empty($articles)): ?>
            <div class="col-12 text-center py-5 text-muted">
                <i class="bi bi-book fs-2 d-block mb-2"></i>
                No se encontraron artículos.
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- PANEL LATERAL -->
    <div class="col-lg-4">
        <!-- Nuevo artículo (agentes) -->
        <?php if (isAgent()): ?>
        <div class="card mb-3">
            <div class="card-header py-2"><i class="bi bi-pencil-square me-2"></i>Publicar Artículo</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-2">
                        <input type="text" name="title" class="form-control form-control-sm" placeholder="Título del artículo" required>
                    </div>
                    <div class="mb-2">
                        <select name="category_id" class="form-select form-select-sm">
                            <option value="">Categoría</option>
                            <?php foreach ($cats as $c): ?>
                            <option value="<?= $c['id'] ?>"><?= sanitize($c['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-2">
                        <textarea name="content" class="form-control form-control-sm" rows="5"
                                  placeholder="Contenido del artículo (HTML permitido)" required></textarea>
                    </div>
                    <div class="mb-3">
                        <input type="text" name="tags" class="form-control form-control-sm" placeholder="Tags: vpn,red,contraseña">
                    </div>
                    <button type="submit" class="btn btn-primary btn-sm w-100">
                        <i class="bi bi-upload me-1"></i>Publicar
                    </button>
                </form>
            </div>
        </div>
        <?php endif; ?>

        <!-- Artículos más vistos -->
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-fire me-2 text-danger"></i>Más Consultados</div>
            <div class="card-body p-0">
                <?php
                $top = db()->fetchAll("SELECT id, title, views FROM knowledge_base WHERE published=1 ORDER BY views DESC LIMIT 5");
                foreach ($top as $t):
                ?>
                <a href="<?= BASE_URL ?>/knowledge.php?id=<?= $t['id'] ?>" class="list-group-item list-group-item-action py-2 small d-flex justify-content-between">
                    <span><i class="bi bi-file-text me-2 text-primary"></i><?= sanitize($t['title']) ?></span>
                    <span class="text-muted"><?= $t['views'] ?> visitas</span>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
