<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$page      = 'ticket-create';
$pageTitle = 'Nuevo Ticket';

$errors = [];
$cats   = db()->fetchAll("SELECT * FROM categories WHERE parent_id IS NULL AND active=1 ORDER BY name");
$assets = db()->fetchAll("SELECT id, asset_tag, name FROM assets WHERE status='active' ORDER BY name");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title    = trim($_POST['title'] ?? '');
    $desc     = trim($_POST['description'] ?? '');
    $priority = $_POST['priority'] ?? 'medium';
    $catId    = $_POST['category_id'] ?? null;
    $subcatId = $_POST['subcategory_id'] ?? null;
    $assetId  = $_POST['asset_id'] ?? null;

    if (strlen($title) < 5)  $errors[] = 'El título debe tener al menos 5 caracteres.';
    if (strlen($desc) < 10)  $errors[] = 'La descripción debe tener al menos 10 caracteres.';
    if (!in_array($priority, ['low','medium','high','critical'])) $errors[] = 'Prioridad inválida.';

    if (empty($errors)) {
        $ticketId = createTicket([
            'title'          => $title,
            'description'    => $desc,
            'priority'       => $priority,
            'category_id'    => $catId ?: null,
            'subcategory_id' => $subcatId ?: null,
            'asset_id'       => $assetId ?: null,
        ], $_SESSION['user_id']);

        // Subir adjuntos
        if (!empty($_FILES['attachments']['name'][0])) {
            foreach ($_FILES['attachments']['tmp_name'] as $i => $tmp) {
                if ($_FILES['attachments']['error'][$i] !== 0) continue;
                $origName = $_FILES['attachments']['name'][$i];
                $ext      = strtolower(pathinfo($origName, PATHINFO_EXTENSION));
                if (!in_array($ext, ALLOWED_EXTENSIONS)) continue;
                if ($_FILES['attachments']['size'][$i] > MAX_FILE_SIZE) continue;
                $newName  = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '', $origName);
                $dest     = UPLOAD_PATH . $newName;
                if (move_uploaded_file($tmp, $dest)) {
                    db()->insert(
                        "INSERT INTO ticket_attachments (ticket_id, user_id, filename, original_name, file_size, file_type) VALUES (?,?,?,?,?,?)",
                        [$ticketId, $_SESSION['user_id'], $newName, $origName, $_FILES['attachments']['size'][$i], $_FILES['attachments']['type'][$i]]
                    );
                }
            }
        }

        $ticket = db()->fetchOne("SELECT ticket_number FROM tickets WHERE id=?", [$ticketId]);
        flash('success', "Ticket {$ticket['ticket_number']} creado exitosamente.");
        redirect('dashboard.php');
    }
}

require_once __DIR__ . '/includes/header.php';
?>

<div class="row justify-content-center">
<div class="col-lg-8">
<div class="card">
    <div class="card-header py-3">
        <i class="bi bi-plus-circle me-2 text-primary"></i>Crear Nuevo Ticket de Soporte
    </div>
    <div class="card-body p-4">

        <?php foreach ($errors as $e): ?>
        <div class="alert alert-danger py-2"><i class="bi bi-exclamation-circle me-2"></i><?= $e ?></div>
        <?php endforeach; ?>

        <form method="POST" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label fw-semibold">Título del problema <span class="text-danger">*</span></label>
                <input type="text" name="title" class="form-control" required
                       placeholder="Ej: Mi computador no enciende desde esta mañana"
                       value="<?= htmlspecialchars($_POST['title'] ?? '') ?>">
                <div class="form-text">Sea específico y descriptivo en el título.</div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Categoría</label>
                    <select name="category_id" id="catSelect" class="form-select" onchange="loadSubcats(this.value)">
                        <option value="">-- Seleccionar categoría --</option>
                        <?php foreach ($cats as $c): ?>
                        <option value="<?= $c['id'] ?>" <?= ($_POST['category_id']??'')==$c['id']?'selected':'' ?>>
                            <?= sanitize($c['name']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Subcategoría</label>
                    <select name="subcategory_id" id="subcatSelect" class="form-select">
                        <option value="">-- Primero seleccione categoría --</option>
                    </select>
                </div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Prioridad <span class="text-danger">*</span></label>
                    <select name="priority" class="form-select" required>
                        <option value="low"      <?= ($_POST['priority']??'')=='low'?'selected':'' ?>>🟢 Baja - No urgente</option>
                        <option value="medium"   <?= (($_POST['priority']??'medium')=='medium')?'selected':'' ?>>🟡 Media - Normal</option>
                        <option value="high"     <?= ($_POST['priority']??'')=='high'?'selected':'' ?>>🟠 Alta - Afecta trabajo</option>
                        <option value="critical" <?= ($_POST['priority']??'')=='critical'?'selected':'' ?>>🔴 Crítica - Bloqueo total</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Activo relacionado</label>
                    <select name="asset_id" class="form-select">
                        <option value="">-- Sin activo asociado --</option>
                        <?php foreach ($assets as $a): ?>
                        <option value="<?= $a['id'] ?>">[<?= $a['asset_tag'] ?>] <?= sanitize($a['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">Descripción detallada <span class="text-danger">*</span></label>
                <textarea name="description" class="form-control" rows="6" required
                          placeholder="Describa el problema con el mayor detalle posible:&#10;- ¿Cuándo comenzó?&#10;- ¿Qué mensajes de error aparecen?&#10;- ¿Qué intentó hacer para solucionarlo?&#10;- ¿Afecta solo a usted o a más personas?"><?= htmlspecialchars($_POST['description'] ?? '') ?></textarea>
            </div>

            <div class="mb-4">
                <label class="form-label fw-semibold">Archivos adjuntos</label>
                <input type="file" name="attachments[]" class="form-control" multiple
                       accept=".pdf,.doc,.docx,.xls,.xlsx,.jpg,.jpeg,.png,.gif,.zip,.txt,.log">
                <div class="form-text">
                    Adjunte capturas de pantalla, logs o documentos relevantes. 
                    Formatos: PDF, Office, imágenes, ZIP, TXT. Máximo 10MB por archivo.
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-send me-2"></i>Enviar Ticket
                </button>
                <a href="<?= BASE_URL ?>/dashboard.php" class="btn btn-outline-secondary">Cancelar</a>
            </div>
        </form>
    </div>
</div>
</div>
</div>

<?php
$extraJs = '<script>
function loadSubcats(catId) {
    const sel = document.getElementById("subcatSelect");
    sel.innerHTML = "<option value=\"\">Cargando...</option>";
    if (!catId) { sel.innerHTML = "<option value=\"\">-- Primero seleccione categoría --</option>"; return; }
    fetch("<?= BASE_URL ?>/api/subcategories.php?cat_id=" + catId)
        .then(r => r.json())
        .then(data => {
            sel.innerHTML = "<option value=\"\">-- Sin subcategoría --</option>";
            data.forEach(s => sel.innerHTML += `<option value="${s.id}">${s.name}</option>`);
        });
}
</script>';
require_once __DIR__ . '/includes/footer.php';
?>
