<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$id = (int)($_GET['id'] ?? 0);
if (!$id) redirect('tickets.php');

$ticket = db()->fetchOne(
    "SELECT t.*, u.name as requester_name, u.email as requester_email,
            a.name as agent_name, a.email as agent_email,
            c.name as cat_name, sc.name as subcat_name,
            ast.name as asset_name, ast.asset_tag
     FROM tickets t
     JOIN users u ON t.requester_id = u.id
     LEFT JOIN users a ON t.agent_id = a.id
     LEFT JOIN categories c ON t.category_id = c.id
     LEFT JOIN categories sc ON t.subcategory_id = sc.id
     LEFT JOIN assets ast ON t.asset_id = ast.id
     WHERE t.id = ?", [$id]
);

if (!$ticket) redirect('tickets.php');

// Verificar acceso: cliente solo ve sus propios tickets
if ($_SESSION['user_role'] === 'client' && $ticket['requester_id'] != $_SESSION['user_id']) {
    redirect('tickets.php');
}

// ── ACCIONES ────────────────────────────────────────────────
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    // Agregar comentario
    if ($action === 'comment') {
        $msg      = trim($_POST['message'] ?? '');
        $internal = isset($_POST['is_internal']) && isAgent();
        if (strlen($msg) > 2) {
            $commentId = addComment($id, $_SESSION['user_id'], $msg, $internal);
            
            // Adjuntos del comentario
            if (!empty($_FILES['attach']['tmp_name'])) {
                $ext = strtolower(pathinfo($_FILES['attach']['name'], PATHINFO_EXTENSION));
                if (in_array($ext, ALLOWED_EXTENSIONS) && $_FILES['attach']['size'] <= MAX_FILE_SIZE) {
                    $newName = uniqid() . '_' . preg_replace('/[^a-zA-Z0-9._-]/', '', $_FILES['attach']['name']);
                    if (move_uploaded_file($_FILES['attach']['tmp_name'], UPLOAD_PATH . $newName)) {
                        db()->insert(
                            "INSERT INTO ticket_attachments (ticket_id, comment_id, user_id, filename, original_name, file_size, file_type) VALUES (?,?,?,?,?,?,?)",
                            [$id, $commentId, $_SESSION['user_id'], $newName, $_FILES['attach']['name'], $_FILES['attach']['size'], $_FILES['attach']['type']]
                        );
                    }
                }
            }
            // Si cliente responde, cambiar a open
            if (!isAgent() && $ticket['status'] === 'pending') {
                updateTicketStatus($id, 'open', $_SESSION['user_id']);
            }
        }
    }

    // Cambiar estado (solo agentes)
    if ($action === 'status' && isAgent()) {
        $newStatus = $_POST['new_status'] ?? '';
        if (in_array($newStatus, ['open','in_progress','pending','resolved','closed'])) {
            updateTicketStatus($id, $newStatus, $_SESSION['user_id']);
        }
    }

    // Asignar agente (solo admin/agent)
    if ($action === 'assign' && isAgent()) {
        $agentId = (int)$_POST['agent_id'];
        $old     = $ticket['agent_id'];
        db()->execute("UPDATE tickets SET agent_id=?, status='in_progress', updated_at=NOW() WHERE id=?", [$agentId ?: null, $id]);
        auditLog('agent_assigned', 'tickets', $id, ['agent_id' => $old], ['agent_id' => $agentId]);
        if ($agentId) {
            notifyUser($agentId, 'Ticket asignado', "Se te asignó el ticket {$ticket['ticket_number']}.", 'ticket', $id);
        }
    }

    // Cambiar prioridad (solo agentes)
    if ($action === 'priority' && isAgent()) {
        $newPrio = $_POST['new_priority'] ?? '';
        if (in_array($newPrio, ['low','medium','high','critical'])) {
            db()->execute("UPDATE tickets SET priority=?, updated_at=NOW() WHERE id=?", [$newPrio, $id]);
            auditLog('priority_changed', 'tickets', $id, ['priority' => $ticket['priority']], ['priority' => $newPrio]);
        }
    }

    // Recargar
    header('Location: ' . BASE_URL . '/ticket-view.php?id=' . $id);
    exit;
}

// Datos complementarios
$comments    = db()->fetchAll(
    "SELECT tc.*, u.name as author_name, u.role as author_role
     FROM ticket_comments tc JOIN users u ON tc.user_id = u.id
     WHERE tc.ticket_id = ? ORDER BY tc.created_at ASC", [$id]
);
$attachments = db()->fetchAll("SELECT * FROM ticket_attachments WHERE ticket_id=? ORDER BY created_at", [$id]);
$agents      = isAdmin() ? db()->fetchAll("SELECT id, name FROM users WHERE role IN ('admin','agent') AND active=1 ORDER BY name") : [];
$auditTrail  = db()->fetchAll(
    "SELECT al.*, u.name as user_name FROM audit_log al
     LEFT JOIN users u ON al.user_id = u.id
     WHERE al.entity='tickets' AND al.entity_id=?
     ORDER BY al.created_at DESC LIMIT 20", [$id]
);

[$statusLabel, $statusClass] = getStatusLabel($ticket['status']);
[$prioLabel, $prioClass]     = getPriorityLabel($ticket['priority']);
$overdue = $ticket['due_date'] && $ticket['due_date'] < date('Y-m-d H:i:s') && !in_array($ticket['status'], ['resolved','closed']);

$page      = 'tickets';
$pageTitle = $ticket['ticket_number'] . ' - ' . $ticket['title'];

require_once __DIR__ . '/includes/header.php';
?>

<!-- HEADER TICKET -->
<div class="card mb-3">
    <div class="card-body">
        <div class="d-flex flex-wrap justify-content-between align-items-start gap-2">
            <div>
                <div class="d-flex align-items-center gap-2 mb-1">
                    <code class="text-primary fs-6"><?= $ticket['ticket_number'] ?></code>
                    <span class="ticket-badge <?= $statusClass ?>"><?= $statusLabel ?></span>
                    <span class="<?= $prioClass ?> small fw-bold"><?= $prioLabel ?></span>
                    <?php if ($overdue): ?><span class="badge bg-danger">⚠ SLA Vencido</span><?php endif; ?>
                </div>
                <h5 class="mb-0 fw-bold"><?= sanitize($ticket['title']) ?></h5>
            </div>
            <div class="d-flex gap-2">
                <a href="<?= BASE_URL ?>/tickets.php" class="btn btn-sm btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Volver
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- COLUMNA PRINCIPAL -->
    <div class="col-lg-8">

        <!-- DESCRIPCIÓN -->
        <div class="card mb-3">
            <div class="card-header py-2 d-flex justify-content-between">
                <span><i class="bi bi-file-text me-2"></i>Descripción</span>
                <small class="text-muted">por <?= sanitize($ticket['requester_name']) ?> · <?= formatDate($ticket['created_at']) ?></small>
            </div>
            <div class="card-body">
                <p style="white-space:pre-wrap;margin:0;"><?= sanitize($ticket['description']) ?></p>
            </div>
            <?php if ($attachments): ?>
            <div class="card-footer">
                <small class="text-muted fw-semibold">Adjuntos:</small>
                <?php foreach ($attachments as $att): ?>
                <a href="<?= BASE_URL ?>/download.php?id=<?= $att['id'] ?>" class="btn btn-sm btn-outline-secondary ms-2" target="_blank">
                    <i class="bi bi-paperclip"></i> <?= sanitize($att['original_name']) ?>
                    <small>(<?= round($att['file_size']/1024) ?>KB)</small>
                </a>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>

        <!-- COMENTARIOS -->
        <div class="card mb-3">
            <div class="card-header py-2">
                <i class="bi bi-chat-dots me-2"></i>Conversación (<?= count($comments) ?> respuestas)
            </div>
            <div class="card-body">
                <?php if (empty($comments)): ?>
                <p class="text-muted text-center py-2 mb-0">Aún no hay respuestas en este ticket.</p>
                <?php endif; ?>
                <?php foreach ($comments as $c):
                    $isAgent_ = in_array($c['author_role'], ['admin','agent']);
                    $bubbleClass = $c['is_internal'] ? 'internal' : ($isAgent_ ? 'agent' : '');
                ?>
                <div class="comment-bubble <?= $bubbleClass ?>">
                    <div class="d-flex justify-content-between mb-1">
                        <strong class="small">
                            <?= sanitize($c['author_name']) ?>
                            <?php if ($isAgent_): ?><span class="badge bg-primary ms-1" style="font-size:.65rem;">Soporte</span><?php endif; ?>
                            <?php if ($c['is_internal']): ?><span class="badge bg-warning text-dark ms-1" style="font-size:.65rem;">Nota Interna</span><?php endif; ?>
                        </strong>
                        <small class="text-muted"><?= formatDate($c['created_at']) ?></small>
                    </div>
                    <p class="mb-0" style="white-space:pre-wrap;"><?= sanitize($c['message']) ?></p>
                </div>
                <?php endforeach; ?>

                <!-- FORMULARIO RESPUESTA -->
                <?php if (!in_array($ticket['status'], ['closed'])): ?>
                <hr>
                <form method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="action" value="comment">
                    <div class="mb-2">
                        <textarea name="message" class="form-control" rows="4" required
                                  placeholder="Escriba su respuesta aquí..."></textarea>
                    </div>
                    <div class="mb-2">
                        <input type="file" name="attach" class="form-control form-control-sm"
                               accept=".pdf,.doc,.docx,.jpg,.jpeg,.png,.zip,.txt">
                    </div>
                    <div class="d-flex align-items-center justify-content-between">
                        <?php if (isAgent()): ?>
                        <div class="form-check">
                            <input type="checkbox" name="is_internal" id="internalCheck" class="form-check-input">
                            <label class="form-check-label small" for="internalCheck">Nota interna (no visible al cliente)</label>
                        </div>
                        <?php else: ?><div></div><?php endif; ?>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="bi bi-send me-1"></i>Enviar Respuesta
                        </button>
                    </div>
                </form>
                <?php endif; ?>
            </div>
        </div>

        <!-- TRAZABILIDAD / AUDITORÍA -->
        <div class="card">
            <div class="card-header py-2">
                <i class="bi bi-clock-history me-2"></i>Historial de Cambios
            </div>
            <div class="card-body p-0">
                <ul class="list-group list-group-flush">
                    <?php foreach ($auditTrail as $log): ?>
                    <li class="list-group-item py-2">
                        <div class="d-flex justify-content-between">
                            <span class="small">
                                <strong><?= sanitize($log['user_name'] ?? 'Sistema') ?></strong>
                                · <?= sanitize($log['action']) ?>
                            </span>
                            <small class="text-muted"><?= formatDate($log['created_at']) ?></small>
                        </div>
                    </li>
                    <?php endforeach; ?>
                    <?php if (empty($auditTrail)): ?>
                    <li class="list-group-item text-muted small text-center py-3">Sin historial</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- COLUMNA LATERAL -->
    <div class="col-lg-4">

        <!-- INFO DEL TICKET -->
        <div class="card mb-3">
            <div class="card-header py-2"><i class="bi bi-info-circle me-2"></i>Información</div>
            <div class="card-body">
                <table class="table table-sm mb-0" style="font-size:.85rem;">
                    <tr><td class="text-muted">Solicitante</td><td class="fw-semibold"><?= sanitize($ticket['requester_name']) ?></td></tr>
                    <tr><td class="text-muted">Agente</td><td><?= $ticket['agent_name'] ? sanitize($ticket['agent_name']) : '<span class="text-muted">Sin asignar</span>' ?></td></tr>
                    <tr><td class="text-muted">Categoría</td><td><?= sanitize($ticket['cat_name'] ?? '-') ?></td></tr>
                    <tr><td class="text-muted">Subcategoría</td><td><?= sanitize($ticket['subcat_name'] ?? '-') ?></td></tr>
                    <tr><td class="text-muted">Activo</td><td><?= $ticket['asset_tag'] ? "[{$ticket['asset_tag']}] {$ticket['asset_name']}" : '-' ?></td></tr>
                    <tr><td class="text-muted">Fecha límite</td>
                        <td class="<?= $overdue?'text-danger fw-bold':'' ?>"><?= $ticket['due_date'] ? formatDate($ticket['due_date']) : '-' ?></td>
                    </tr>
                    <tr><td class="text-muted">Creado</td><td><?= formatDate($ticket['created_at']) ?></td></tr>
                    <?php if ($ticket['resolved_at']): ?>
                    <tr><td class="text-muted">Resuelto</td><td><?= formatDate($ticket['resolved_at']) ?></td></tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>

        <?php if (isAgent()): ?>
        <!-- ACCIONES AGENTE -->
        <div class="card mb-3">
            <div class="card-header py-2"><i class="bi bi-gear me-2"></i>Acciones</div>
            <div class="card-body">
                <!-- Cambiar estado -->
                <form method="POST" class="mb-3">
                    <input type="hidden" name="action" value="status">
                    <label class="form-label small fw-semibold">Cambiar Estado</label>
                    <div class="input-group input-group-sm">
                        <select name="new_status" class="form-select form-select-sm">
                            <?php foreach (['open'=>'Abierto','in_progress'=>'En Progreso','pending'=>'Pendiente cliente','resolved'=>'Resuelto','closed'=>'Cerrado'] as $k=>$v): ?>
                            <option value="<?= $k ?>" <?= $ticket['status']===$k?'selected':'' ?>><?= $v ?></option>
                            <?php endforeach; ?>
                        </select>
                        <button class="btn btn-outline-primary" type="submit">Guardar</button>
                    </div>
                </form>

                <!-- Cambiar prioridad -->
                <form method="POST" class="mb-3">
                    <input type="hidden" name="action" value="priority">
                    <label class="form-label small fw-semibold">Cambiar Prioridad</label>
                    <div class="input-group input-group-sm">
                        <select name="new_priority" class="form-select form-select-sm">
                            <?php foreach (['low'=>'Baja','medium'=>'Media','high'=>'Alta','critical'=>'Crítica'] as $k=>$v): ?>
                            <option value="<?= $k ?>" <?= $ticket['priority']===$k?'selected':'' ?>><?= $v ?></option>
                            <?php endforeach; ?>
                        </select>
                        <button class="btn btn-outline-warning" type="submit">Guardar</button>
                    </div>
                </form>

                <?php if (isAdmin()): ?>
                <!-- Asignar agente -->
                <form method="POST">
                    <input type="hidden" name="action" value="assign">
                    <label class="form-label small fw-semibold">Asignar Agente</label>
                    <div class="input-group input-group-sm">
                        <select name="agent_id" class="form-select form-select-sm">
                            <option value="">Sin asignar</option>
                            <?php foreach ($agents as $ag): ?>
                            <option value="<?= $ag['id'] ?>" <?= $ticket['agent_id']==$ag['id']?'selected':'' ?>><?= sanitize($ag['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                        <button class="btn btn-outline-success" type="submit">Asignar</button>
                    </div>
                </form>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- ARTÍCULOS RELACIONADOS KB -->
        <div class="card">
            <div class="card-header py-2"><i class="bi bi-lightbulb me-2 text-warning"></i>Artículos Relacionados</div>
            <div class="card-body p-0">
                <?php
                $kbArticles = db()->fetchAll(
                    "SELECT id, title FROM knowledge_base WHERE published=1 AND category_id=? LIMIT 3",
                    [$ticket['category_id'] ?? 0]
                );
                if ($kbArticles): foreach ($kbArticles as $kb): ?>
                <a href="<?= BASE_URL ?>/knowledge.php?id=<?= $kb['id'] ?>" class="list-group-item list-group-item-action py-2 small">
                    <i class="bi bi-file-text me-2 text-primary"></i><?= sanitize($kb['title']) ?>
                </a>
                <?php endforeach; else: ?>
                <div class="p-3 text-muted small text-center">No hay artículos relacionados</div>
                <?php endif; ?>
                <div class="p-2 text-center">
                    <a href="<?= BASE_URL ?>/knowledge.php" class="small text-primary">Ver base de conocimiento →</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
