<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/functions.php';

startSession();
requireLogin();

$page      = 'tickets';
$pageTitle = 'Gestión de Tickets';
$uid       = $_SESSION['user_id'];
$role      = $_SESSION['user_role'];

// Filtros
$viewAll  = isset($_GET['view']) && $_GET['view'] === 'all' && isAgent();
$status   = $_GET['status']   ?? '';
$priority = $_GET['priority'] ?? '';
$search   = trim($_GET['q']   ?? '');
$page_num = max(1, (int)($_GET['p'] ?? 1));
$perPage  = 15;

$where  = ['1=1'];
$params = [];

if (!$viewAll) {
    $where[]  = 't.requester_id = ?';
    $params[] = $uid;
}
if ($status)   { $where[] = 't.status = ?';   $params[] = $status; }
if ($priority) { $where[] = 't.priority = ?'; $params[] = $priority; }
if ($search)   { $where[] = '(t.title LIKE ? OR t.ticket_number LIKE ?)'; $params[] = "%$search%"; $params[] = "%$search%"; }

$whereStr = implode(' AND ', $where);
$total    = db()->fetchOne("SELECT COUNT(*) c FROM tickets t WHERE $whereStr", $params)['c'];
$offset   = ($page_num - 1) * $perPage;
$pages    = ceil($total / $perPage);

$tickets = db()->fetchAll(
    "SELECT t.*, u.name as requester_name, a.name as agent_name, c.name as cat_name
     FROM tickets t
     JOIN users u ON t.requester_id = u.id
     LEFT JOIN users a ON t.agent_id = a.id
     LEFT JOIN categories c ON t.category_id = c.id
     WHERE $whereStr
     ORDER BY FIELD(t.priority,'critical','high','medium','low'), t.created_at DESC
     LIMIT $perPage OFFSET $offset",
    $params
);

require_once __DIR__ . '/includes/header.php';
?>

<!-- FILTERS BAR -->
<div class="card mb-3">
    <div class="card-body py-2">
        <form method="GET" class="row g-2 align-items-center">
            <?php if (isAgent()): ?>
            <input type="hidden" name="view" value="<?= $viewAll?'all':'' ?>">
            <?php endif; ?>
            <div class="col-md-4">
                <input type="text" name="q" class="form-control form-control-sm" placeholder="🔍 Buscar por título o número..." value="<?= htmlspecialchars($search) ?>">
            </div>
            <div class="col-auto">
                <select name="status" class="form-select form-select-sm">
                    <option value="">Todos los estados</option>
                    <?php foreach (['open'=>'Abierto','in_progress'=>'En Progreso','pending'=>'Pendiente','resolved'=>'Resuelto','closed'=>'Cerrado'] as $k=>$v): ?>
                    <option value="<?= $k ?>" <?= $status===$k?'selected':'' ?>><?= $v ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-auto">
                <select name="priority" class="form-select form-select-sm">
                    <option value="">Todas las prioridades</option>
                    <?php foreach (['low'=>'Baja','medium'=>'Media','high'=>'Alta','critical'=>'Crítica'] as $k=>$v): ?>
                    <option value="<?= $k ?>" <?= $priority===$k?'selected':'' ?>><?= $v ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                <a href="<?= BASE_URL ?>/tickets.php<?= $viewAll?'?view=all':'' ?>" class="btn btn-sm btn-outline-secondary">Limpiar</a>
            </div>
            <div class="col-auto ms-auto">
                <span class="text-muted small"><?= $total ?> tickets</span>
            </div>
        </form>
    </div>
</div>

<!-- TABS (solo agentes) -->
<?php if (isAgent()): ?>
<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link <?= !$viewAll?'active':'' ?>" href="<?= BASE_URL ?>/tickets.php">Mis Asignaciones</a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?= $viewAll?'active':'' ?>" href="<?= BASE_URL ?>/tickets.php?view=all">Todos los Tickets</a>
    </li>
</ul>
<?php endif; ?>

<!-- TICKETS TABLE -->
<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th>N° Ticket</th>
                        <th>Título</th>
                        <th>Categoría</th>
                        <th>Estado</th>
                        <th>Prioridad</th>
                        <?php if (isAgent()): ?><th>Solicitante</th><th>Agente</th><?php endif; ?>
                        <th>Fecha Límite SLA</th>
                        <th>Creado</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($tickets as $t):
                        [$statusLabel, $statusClass] = getStatusLabel($t['status']);
                        [$prioLabel, $prioClass]     = getPriorityLabel($t['priority']);
                        $overdue = $t['due_date'] && $t['due_date'] < date('Y-m-d H:i:s') && !in_array($t['status'], ['resolved','closed']);
                    ?>
                    <tr onclick="location.href='<?= BASE_URL ?>/ticket-view.php?id=<?= $t['id'] ?>'"
                        style="<?= $overdue?'background:#FFF5F5;':'' ?>">
                        <td>
                            <code class="text-primary"><?= $t['ticket_number'] ?></code>
                            <?php if ($overdue): ?><span class="badge bg-danger ms-1" style="font-size:.6rem;">SLA</span><?php endif; ?>
                        </td>
                        <td style="max-width:200px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;" class="fw-semibold">
                            <?= sanitize($t['title']) ?>
                        </td>
                        <td><small><?= sanitize($t['cat_name'] ?? '-') ?></small></td>
                        <td><span class="ticket-badge <?= $statusClass ?>"><?= $statusLabel ?></span></td>
                        <td><span class="<?= $prioClass ?> small fw-semibold"><?= $prioLabel ?></span></td>
                        <?php if (isAgent()): ?>
                        <td><small><?= sanitize($t['requester_name']) ?></small></td>
                        <td><small><?= $t['agent_name'] ? sanitize($t['agent_name']) : '<span class="text-muted">Sin asignar</span>' ?></small></td>
                        <?php endif; ?>
                        <td>
                            <small class="<?= $overdue?'text-danger fw-bold':'' ?>">
                                <?= $t['due_date'] ? date('d/m H:i', strtotime($t['due_date'])) : '-' ?>
                            </small>
                        </td>
                        <td><small class="text-muted"><?= timeAgo($t['created_at']) ?></small></td>
                        <td>
                            <a href="<?= BASE_URL ?>/ticket-view.php?id=<?= $t['id'] ?>" class="btn btn-sm btn-outline-primary" onclick="event.stopPropagation()">
                                <i class="bi bi-eye"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($tickets)): ?>
                    <tr><td colspan="10" class="text-center text-muted py-5">
                        <i class="bi bi-inbox fs-2 d-block mb-2 text-muted"></i>
                        No se encontraron tickets con los filtros actuales.
                        <br><a href="<?= BASE_URL ?>/ticket-create.php" class="btn btn-primary btn-sm mt-3">Crear nuevo ticket</a>
                    </td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if ($pages > 1): ?>
    <div class="card-footer">
        <nav><ul class="pagination pagination-sm mb-0 justify-content-center">
            <?php for ($i = 1; $i <= $pages; $i++): ?>
            <li class="page-item <?= $i===$page_num?'active':'' ?>">
                <a class="page-link" href="?p=<?= $i ?>&status=<?= $status ?>&priority=<?= $priority ?>&q=<?= urlencode($search) ?><?= $viewAll?'&view=all':'' ?>"><?= $i ?></a>
            </li>
            <?php endfor; ?>
        </ul></nav>
    </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
